/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.eureka;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.ServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.niws.loadbalancer.NIWSDiscoveryPing;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.ribbon.eureka.DomainExtractingServerList;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EurekaRibbonClientConfiguration {
    @Value(value="${ribbon.eureka.approximateZoneFromHostname:false}")
    private boolean approximateZoneFromHostname = false;
    @Value(value="${ribbon.client.name}")
    private String serviceId = "client";
    protected static final String VALUE_NOT_SET = "__not__set__";
    protected static final String DEFAULT_NAMESPACE = "ribbon";
    @Autowired(required=false)
    private EurekaClientConfig clientConfig;

    public EurekaRibbonClientConfiguration() {
    }

    public EurekaRibbonClientConfiguration(EurekaClientConfig clientConfig, String serviceId) {
        this.clientConfig = clientConfig;
        this.serviceId = serviceId;
    }

    @Bean
    @ConditionalOnMissingBean
    public IPing ribbonPing(IClientConfig config) {
        NIWSDiscoveryPing ping = new NIWSDiscoveryPing();
        ping.initWithNiwsConfig(config);
        return ping;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerList<?> ribbonServerList(IClientConfig config) {
        DiscoveryEnabledNIWSServerList discoveryServerList = new DiscoveryEnabledNIWSServerList(config);
        DomainExtractingServerList serverList = new DomainExtractingServerList((ServerList<DiscoveryEnabledServer>)discoveryServerList, config, this.approximateZoneFromHostname);
        return serverList;
    }

    @PostConstruct
    public void preprocess() {
        if (this.clientConfig != null && ConfigurationManager.getDeploymentContext().getValue(DeploymentContext.ContextKey.zone) == null) {
            String zone;
            String[] zones = this.clientConfig.getAvailabilityZones(this.clientConfig.getRegion());
            String string = zone = zones != null && zones.length > 0 ? zones[0] : null;
            if (zone != null) {
                ConfigurationManager.getDeploymentContext().setValue(DeploymentContext.ContextKey.zone, zone);
            }
        }
        this.setProp(this.serviceId, CommonClientConfigKey.DeploymentContextBasedVipAddresses.key(), this.serviceId);
        this.setProp(this.serviceId, CommonClientConfigKey.EnableZoneAffinity.key(), "true");
    }

    protected void setProp(String serviceId, String suffix, String value) {
        String key = this.getKey(serviceId, suffix);
        DynamicStringProperty property = this.getProperty(key);
        if (property.get().equals(VALUE_NOT_SET)) {
            ConfigurationManager.getConfigInstance().setProperty(key, (Object)value);
        }
    }

    protected DynamicStringProperty getProperty(String key) {
        return DynamicPropertyFactory.getInstance().getStringProperty(key, VALUE_NOT_SET);
    }

    protected String getKey(String serviceId, String suffix) {
        return String.valueOf(serviceId) + "." + DEFAULT_NAMESPACE + "." + suffix;
    }
}

