/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Servlet30WrapperFilter
extends ZuulFilter {
    private Field requestField = ReflectionUtils.findField(HttpServletRequestWrapper.class, (String)"req", HttpServletRequest.class);

    public Servlet30WrapperFilter() {
        Assert.notNull((Object)this.requestField, (String)"HttpServletRequestWrapper.req field not found");
        this.requestField.setAccessible(true);
    }

    protected Field getRequestField() {
        return this.requestField;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        if (request instanceof HttpServletRequestWrapper) {
            request = (HttpServletRequest)ReflectionUtils.getField((Field)this.requestField, (Object)request);
        }
        ctx.setRequest((HttpServletRequest)new Servlet30RequestWrapper(request));
        return null;
    }

    private class Servlet30RequestWrapper
    extends HttpServletRequestWrapper {
        private HttpServletRequest request;

        Servlet30RequestWrapper(HttpServletRequest request) {
            super(request);
            this.request = request;
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            return this.request.authenticate(response);
        }

        public void login(String username, String password) throws ServletException {
            this.request.login(username, password);
        }

        public void logout() throws ServletException {
            this.request.logout();
        }

        public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
            return this.request.getParts();
        }

        public Part getPart(String name) throws IOException, IllegalStateException, ServletException {
            return this.request.getPart(name);
        }

        public ServletContext getServletContext() {
            return this.request.getServletContext();
        }

        public AsyncContext startAsync() {
            return this.request.startAsync();
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
            return this.request.startAsync(servletRequest, servletResponse);
        }

        public boolean isAsyncStarted() {
            try {
                return this.request.isAsyncStarted();
            }
            catch (Throwable e) {
                return false;
            }
        }

        public boolean isAsyncSupported() {
            try {
                return this.request.isAsyncSupported();
            }
            catch (Throwable e) {
                return false;
            }
        }

        public AsyncContext getAsyncContext() {
            return this.request.getAsyncContext();
        }

        public DispatcherType getDispatcherType() {
            return this.request.getDispatcherType();
        }
    }
}

