/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.config;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

@ConditionalOnClass(value={DiscoveryClient.class, ConfigServicePropertySourceLocator.class})
@ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"}, matchIfMissing=false)
@Configuration
@EnableDiscoveryClient
@Import(value={EurekaClientAutoConfiguration.class})
public class DiscoveryClientConfigServiceBootstrapConfiguration
implements SmartApplicationListener {
    private static final Log log = LogFactory.getLog(DiscoveryClientConfigServiceBootstrapConfiguration.class);
    private HeartbeatMonitor monitor = new HeartbeatMonitor();
    @Autowired
    private ConfigClientProperties config;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.refresh();
        } else if (event instanceof HeartbeatEvent && this.monitor.update(((HeartbeatEvent)event).getValue())) {
            this.refresh();
        }
    }

    public int getOrder() {
        return 0;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ContextRefreshedEvent.class.isAssignableFrom(eventType) || HeartbeatEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    private void refresh() {
        try {
            log.info((Object)"Locating configserver via discovery");
            InstanceInfo server = DiscoveryManager.getInstance().getDiscoveryClient().getNextServerFromEureka(this.config.getDiscovery().getServiceId(), false);
            String url = server.getHomePageUrl();
            if (server.getMetadata().containsKey("password")) {
                String user = (String)server.getMetadata().get("user");
                user = user == null ? "user" : user;
                this.config.setUsername(user);
                String password = (String)server.getMetadata().get("password");
                this.config.setPassword(password);
            }
            if (server.getMetadata().containsKey("configPath")) {
                String path = (String)server.getMetadata().get("configPath");
                if (url.endsWith("/") && path.startsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                url = url + path;
            }
            this.config.setUri(url);
        }
        catch (Exception ex) {
            log.warn((Object)"Could not locate configserver via discovery", (Throwable)ex);
        }
    }
}

