/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.eureka.EurekaServerConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="eureka.server")
public class EurekaServerConfigBean
implements EurekaServerConfig {
    public static final String DEFAULT_PREFIX = "/eureka";
    private static final int MINUTES = 60000;
    private String aWSAccessId;
    private String aWSSecretKey;
    private int eIPBindRebindRetries = 3;
    private int eIPBindingRetryIntervalMs = 300000;
    private boolean enableSelfPreservation = true;
    private double renewalPercentThreshold = 0.85;
    private int renewalThresholdUpdateIntervalMs = 600000;
    private int peerEurekaNodesUpdateIntervalMs = 900000;
    private int numberOfReplicationRetries = 5;
    private int peerEurekaStatusRefreshTimeIntervalMs = 30000;
    private int waitTimeInMsWhenSyncEmpty = 300000;
    private int peerNodeConnectTimeoutMs = 200;
    private int peerNodeReadTimeoutMs = 200;
    private int peerNodeTotalConnections = 1000;
    private int peerNodeTotalConnectionsPerHost = 500;
    private int peerNodeConnectionIdleTimeoutSeconds = 30;
    private long retentionTimeInMSInDeltaQueue = 180000L;
    private long deltaRetentionTimerIntervalInMs = 30000L;
    private long evictionIntervalTimerInMs = 60000L;
    private int aSGQueryTimeoutMs = 300;
    private long aSGUpdateIntervalMs = 300000L;
    private long responseCacheAutoExpirationInSeconds = 180L;
    private long responseCacheUpdateIntervalMs = 30000L;
    private boolean disableDelta;
    private long maxIdleThreadInMinutesAgeForStatusReplication = 10L;
    private int minThreadsForStatusReplication = 1;
    private int maxThreadsForStatusReplication = 1;
    private int maxElementsInStatusReplicationPool = 10000;
    private boolean syncWhenTimestampDiffers = true;
    private int registrySyncRetries = 5;
    private int maxElementsInPeerReplicationPool = 10000;
    private long maxIdleThreadAgeInMinutesForPeerReplication = 15L;
    private int minThreadsForPeerReplication = 5;
    private int maxThreadsForPeerReplication = 20;
    private int maxTimeForReplication = 30000;
    private boolean primeAwsReplicaConnections = true;
    private boolean disableDeltaForRemoteRegions;
    private int remoteRegionConnectTimeoutMs = 1000;
    private int remoteRegionReadTimeoutMs = 1000;
    private int remoteRegionTotalConnections = 1000;
    private int remoteRegionTotalConnectionsPerHost = 500;
    private int remoteRegionConnectionIdleTimeoutSeconds = 30;
    private boolean gZipContentFromRemoteRegion = true;
    private Map<String, String> remoteRegionUrlsWithName = new HashMap<String, String>();
    private String[] remoteRegionUrls;
    private Map<String, Set<String>> remoteRegionAppWhitelist;
    private int remoteRegionRegistryFetchInterval = 30;
    private String remoteRegionTrustStore = "";
    private String remoteRegionTrustStorePassword = "changeit";
    private boolean disableTransparentFallbackToOtherRegion;
    private boolean batchReplication;
    private boolean rateLimiterEnabled = false;
    private boolean rateLimiterThrottleStandardClients = false;
    private Set<String> rateLimiterPrivilegedClients = Collections.emptySet();
    private int rateLimiterBurstSize = 10;
    private int rateLimiterRegistryFetchAverageRate = 500;
    private int rateLimiterFullFetchAverageRate = 100;
    private boolean logIdentityHeaders = true;

    public boolean shouldEnableSelfPreservation() {
        return this.enableSelfPreservation;
    }

    public boolean shouldDisableDelta() {
        return this.disableDelta;
    }

    public boolean shouldSyncWhenTimestampDiffers() {
        return this.syncWhenTimestampDiffers;
    }

    public boolean shouldPrimeAwsReplicaConnections() {
        return this.primeAwsReplicaConnections;
    }

    public boolean shouldDisableDeltaForRemoteRegions() {
        return this.disableDeltaForRemoteRegions;
    }

    public boolean shouldGZipContentFromRemoteRegion() {
        return this.gZipContentFromRemoteRegion;
    }

    public Set<String> getRemoteRegionAppWhitelist(String regionName) {
        return this.remoteRegionAppWhitelist.get(regionName == null ? "global" : regionName.trim().toLowerCase());
    }

    public boolean disableTransparentFallbackToOtherRegion() {
        return this.disableTransparentFallbackToOtherRegion;
    }

    public boolean shouldBatchReplication() {
        return this.batchReplication;
    }

    public boolean shouldLogIdentityHeaders() {
        return this.logIdentityHeaders;
    }

    public String getAWSAccessId() {
        return this.aWSAccessId;
    }

    public String getAWSSecretKey() {
        return this.aWSSecretKey;
    }

    public int getEIPBindRebindRetries() {
        return this.eIPBindRebindRetries;
    }

    public int getEIPBindingRetryIntervalMs() {
        return this.eIPBindingRetryIntervalMs;
    }

    public boolean isEnableSelfPreservation() {
        return this.enableSelfPreservation;
    }

    public double getRenewalPercentThreshold() {
        return this.renewalPercentThreshold;
    }

    public int getRenewalThresholdUpdateIntervalMs() {
        return this.renewalThresholdUpdateIntervalMs;
    }

    public int getPeerEurekaNodesUpdateIntervalMs() {
        return this.peerEurekaNodesUpdateIntervalMs;
    }

    public int getNumberOfReplicationRetries() {
        return this.numberOfReplicationRetries;
    }

    public int getPeerEurekaStatusRefreshTimeIntervalMs() {
        return this.peerEurekaStatusRefreshTimeIntervalMs;
    }

    public int getWaitTimeInMsWhenSyncEmpty() {
        return this.waitTimeInMsWhenSyncEmpty;
    }

    public int getPeerNodeConnectTimeoutMs() {
        return this.peerNodeConnectTimeoutMs;
    }

    public int getPeerNodeReadTimeoutMs() {
        return this.peerNodeReadTimeoutMs;
    }

    public int getPeerNodeTotalConnections() {
        return this.peerNodeTotalConnections;
    }

    public int getPeerNodeTotalConnectionsPerHost() {
        return this.peerNodeTotalConnectionsPerHost;
    }

    public int getPeerNodeConnectionIdleTimeoutSeconds() {
        return this.peerNodeConnectionIdleTimeoutSeconds;
    }

    public long getRetentionTimeInMSInDeltaQueue() {
        return this.retentionTimeInMSInDeltaQueue;
    }

    public long getDeltaRetentionTimerIntervalInMs() {
        return this.deltaRetentionTimerIntervalInMs;
    }

    public long getEvictionIntervalTimerInMs() {
        return this.evictionIntervalTimerInMs;
    }

    public int getASGQueryTimeoutMs() {
        return this.aSGQueryTimeoutMs;
    }

    public long getASGUpdateIntervalMs() {
        return this.aSGUpdateIntervalMs;
    }

    public long getResponseCacheAutoExpirationInSeconds() {
        return this.responseCacheAutoExpirationInSeconds;
    }

    public long getResponseCacheUpdateIntervalMs() {
        return this.responseCacheUpdateIntervalMs;
    }

    public boolean isDisableDelta() {
        return this.disableDelta;
    }

    public long getMaxIdleThreadInMinutesAgeForStatusReplication() {
        return this.maxIdleThreadInMinutesAgeForStatusReplication;
    }

    public int getMinThreadsForStatusReplication() {
        return this.minThreadsForStatusReplication;
    }

    public int getMaxThreadsForStatusReplication() {
        return this.maxThreadsForStatusReplication;
    }

    public int getMaxElementsInStatusReplicationPool() {
        return this.maxElementsInStatusReplicationPool;
    }

    public boolean isSyncWhenTimestampDiffers() {
        return this.syncWhenTimestampDiffers;
    }

    public int getRegistrySyncRetries() {
        return this.registrySyncRetries;
    }

    public int getMaxElementsInPeerReplicationPool() {
        return this.maxElementsInPeerReplicationPool;
    }

    public long getMaxIdleThreadAgeInMinutesForPeerReplication() {
        return this.maxIdleThreadAgeInMinutesForPeerReplication;
    }

    public int getMinThreadsForPeerReplication() {
        return this.minThreadsForPeerReplication;
    }

    public int getMaxThreadsForPeerReplication() {
        return this.maxThreadsForPeerReplication;
    }

    public int getMaxTimeForReplication() {
        return this.maxTimeForReplication;
    }

    public boolean isPrimeAwsReplicaConnections() {
        return this.primeAwsReplicaConnections;
    }

    public boolean isDisableDeltaForRemoteRegions() {
        return this.disableDeltaForRemoteRegions;
    }

    public int getRemoteRegionConnectTimeoutMs() {
        return this.remoteRegionConnectTimeoutMs;
    }

    public int getRemoteRegionReadTimeoutMs() {
        return this.remoteRegionReadTimeoutMs;
    }

    public int getRemoteRegionTotalConnections() {
        return this.remoteRegionTotalConnections;
    }

    public int getRemoteRegionTotalConnectionsPerHost() {
        return this.remoteRegionTotalConnectionsPerHost;
    }

    public int getRemoteRegionConnectionIdleTimeoutSeconds() {
        return this.remoteRegionConnectionIdleTimeoutSeconds;
    }

    public boolean isGZipContentFromRemoteRegion() {
        return this.gZipContentFromRemoteRegion;
    }

    public Map<String, String> getRemoteRegionUrlsWithName() {
        return this.remoteRegionUrlsWithName;
    }

    public String[] getRemoteRegionUrls() {
        return this.remoteRegionUrls;
    }

    public Map<String, Set<String>> getRemoteRegionAppWhitelist() {
        return this.remoteRegionAppWhitelist;
    }

    public int getRemoteRegionRegistryFetchInterval() {
        return this.remoteRegionRegistryFetchInterval;
    }

    public String getRemoteRegionTrustStore() {
        return this.remoteRegionTrustStore;
    }

    public String getRemoteRegionTrustStorePassword() {
        return this.remoteRegionTrustStorePassword;
    }

    public boolean isDisableTransparentFallbackToOtherRegion() {
        return this.disableTransparentFallbackToOtherRegion;
    }

    public boolean isBatchReplication() {
        return this.batchReplication;
    }

    public boolean isRateLimiterEnabled() {
        return this.rateLimiterEnabled;
    }

    public boolean isRateLimiterThrottleStandardClients() {
        return this.rateLimiterThrottleStandardClients;
    }

    public Set<String> getRateLimiterPrivilegedClients() {
        return this.rateLimiterPrivilegedClients;
    }

    public int getRateLimiterBurstSize() {
        return this.rateLimiterBurstSize;
    }

    public int getRateLimiterRegistryFetchAverageRate() {
        return this.rateLimiterRegistryFetchAverageRate;
    }

    public int getRateLimiterFullFetchAverageRate() {
        return this.rateLimiterFullFetchAverageRate;
    }

    public boolean isLogIdentityHeaders() {
        return this.logIdentityHeaders;
    }

    public void setAWSAccessId(String aWSAccessId) {
        this.aWSAccessId = aWSAccessId;
    }

    public void setAWSSecretKey(String aWSSecretKey) {
        this.aWSSecretKey = aWSSecretKey;
    }

    public void setEIPBindRebindRetries(int eIPBindRebindRetries) {
        this.eIPBindRebindRetries = eIPBindRebindRetries;
    }

    public void setEIPBindingRetryIntervalMs(int eIPBindingRetryIntervalMs) {
        this.eIPBindingRetryIntervalMs = eIPBindingRetryIntervalMs;
    }

    public void setEnableSelfPreservation(boolean enableSelfPreservation) {
        this.enableSelfPreservation = enableSelfPreservation;
    }

    public void setRenewalPercentThreshold(double renewalPercentThreshold) {
        this.renewalPercentThreshold = renewalPercentThreshold;
    }

    public void setRenewalThresholdUpdateIntervalMs(int renewalThresholdUpdateIntervalMs) {
        this.renewalThresholdUpdateIntervalMs = renewalThresholdUpdateIntervalMs;
    }

    public void setPeerEurekaNodesUpdateIntervalMs(int peerEurekaNodesUpdateIntervalMs) {
        this.peerEurekaNodesUpdateIntervalMs = peerEurekaNodesUpdateIntervalMs;
    }

    public void setNumberOfReplicationRetries(int numberOfReplicationRetries) {
        this.numberOfReplicationRetries = numberOfReplicationRetries;
    }

    public void setPeerEurekaStatusRefreshTimeIntervalMs(int peerEurekaStatusRefreshTimeIntervalMs) {
        this.peerEurekaStatusRefreshTimeIntervalMs = peerEurekaStatusRefreshTimeIntervalMs;
    }

    public void setWaitTimeInMsWhenSyncEmpty(int waitTimeInMsWhenSyncEmpty) {
        this.waitTimeInMsWhenSyncEmpty = waitTimeInMsWhenSyncEmpty;
    }

    public void setPeerNodeConnectTimeoutMs(int peerNodeConnectTimeoutMs) {
        this.peerNodeConnectTimeoutMs = peerNodeConnectTimeoutMs;
    }

    public void setPeerNodeReadTimeoutMs(int peerNodeReadTimeoutMs) {
        this.peerNodeReadTimeoutMs = peerNodeReadTimeoutMs;
    }

    public void setPeerNodeTotalConnections(int peerNodeTotalConnections) {
        this.peerNodeTotalConnections = peerNodeTotalConnections;
    }

    public void setPeerNodeTotalConnectionsPerHost(int peerNodeTotalConnectionsPerHost) {
        this.peerNodeTotalConnectionsPerHost = peerNodeTotalConnectionsPerHost;
    }

    public void setPeerNodeConnectionIdleTimeoutSeconds(int peerNodeConnectionIdleTimeoutSeconds) {
        this.peerNodeConnectionIdleTimeoutSeconds = peerNodeConnectionIdleTimeoutSeconds;
    }

    public void setRetentionTimeInMSInDeltaQueue(long retentionTimeInMSInDeltaQueue) {
        this.retentionTimeInMSInDeltaQueue = retentionTimeInMSInDeltaQueue;
    }

    public void setDeltaRetentionTimerIntervalInMs(long deltaRetentionTimerIntervalInMs) {
        this.deltaRetentionTimerIntervalInMs = deltaRetentionTimerIntervalInMs;
    }

    public void setEvictionIntervalTimerInMs(long evictionIntervalTimerInMs) {
        this.evictionIntervalTimerInMs = evictionIntervalTimerInMs;
    }

    public void setASGQueryTimeoutMs(int aSGQueryTimeoutMs) {
        this.aSGQueryTimeoutMs = aSGQueryTimeoutMs;
    }

    public void setASGUpdateIntervalMs(long aSGUpdateIntervalMs) {
        this.aSGUpdateIntervalMs = aSGUpdateIntervalMs;
    }

    public void setResponseCacheAutoExpirationInSeconds(long responseCacheAutoExpirationInSeconds) {
        this.responseCacheAutoExpirationInSeconds = responseCacheAutoExpirationInSeconds;
    }

    public void setResponseCacheUpdateIntervalMs(long responseCacheUpdateIntervalMs) {
        this.responseCacheUpdateIntervalMs = responseCacheUpdateIntervalMs;
    }

    public void setDisableDelta(boolean disableDelta) {
        this.disableDelta = disableDelta;
    }

    public void setMaxIdleThreadInMinutesAgeForStatusReplication(long maxIdleThreadInMinutesAgeForStatusReplication) {
        this.maxIdleThreadInMinutesAgeForStatusReplication = maxIdleThreadInMinutesAgeForStatusReplication;
    }

    public void setMinThreadsForStatusReplication(int minThreadsForStatusReplication) {
        this.minThreadsForStatusReplication = minThreadsForStatusReplication;
    }

    public void setMaxThreadsForStatusReplication(int maxThreadsForStatusReplication) {
        this.maxThreadsForStatusReplication = maxThreadsForStatusReplication;
    }

    public void setMaxElementsInStatusReplicationPool(int maxElementsInStatusReplicationPool) {
        this.maxElementsInStatusReplicationPool = maxElementsInStatusReplicationPool;
    }

    public void setSyncWhenTimestampDiffers(boolean syncWhenTimestampDiffers) {
        this.syncWhenTimestampDiffers = syncWhenTimestampDiffers;
    }

    public void setRegistrySyncRetries(int registrySyncRetries) {
        this.registrySyncRetries = registrySyncRetries;
    }

    public void setMaxElementsInPeerReplicationPool(int maxElementsInPeerReplicationPool) {
        this.maxElementsInPeerReplicationPool = maxElementsInPeerReplicationPool;
    }

    public void setMaxIdleThreadAgeInMinutesForPeerReplication(long maxIdleThreadAgeInMinutesForPeerReplication) {
        this.maxIdleThreadAgeInMinutesForPeerReplication = maxIdleThreadAgeInMinutesForPeerReplication;
    }

    public void setMinThreadsForPeerReplication(int minThreadsForPeerReplication) {
        this.minThreadsForPeerReplication = minThreadsForPeerReplication;
    }

    public void setMaxThreadsForPeerReplication(int maxThreadsForPeerReplication) {
        this.maxThreadsForPeerReplication = maxThreadsForPeerReplication;
    }

    public void setMaxTimeForReplication(int maxTimeForReplication) {
        this.maxTimeForReplication = maxTimeForReplication;
    }

    public void setPrimeAwsReplicaConnections(boolean primeAwsReplicaConnections) {
        this.primeAwsReplicaConnections = primeAwsReplicaConnections;
    }

    public void setDisableDeltaForRemoteRegions(boolean disableDeltaForRemoteRegions) {
        this.disableDeltaForRemoteRegions = disableDeltaForRemoteRegions;
    }

    public void setRemoteRegionConnectTimeoutMs(int remoteRegionConnectTimeoutMs) {
        this.remoteRegionConnectTimeoutMs = remoteRegionConnectTimeoutMs;
    }

    public void setRemoteRegionReadTimeoutMs(int remoteRegionReadTimeoutMs) {
        this.remoteRegionReadTimeoutMs = remoteRegionReadTimeoutMs;
    }

    public void setRemoteRegionTotalConnections(int remoteRegionTotalConnections) {
        this.remoteRegionTotalConnections = remoteRegionTotalConnections;
    }

    public void setRemoteRegionTotalConnectionsPerHost(int remoteRegionTotalConnectionsPerHost) {
        this.remoteRegionTotalConnectionsPerHost = remoteRegionTotalConnectionsPerHost;
    }

    public void setRemoteRegionConnectionIdleTimeoutSeconds(int remoteRegionConnectionIdleTimeoutSeconds) {
        this.remoteRegionConnectionIdleTimeoutSeconds = remoteRegionConnectionIdleTimeoutSeconds;
    }

    public void setGZipContentFromRemoteRegion(boolean gZipContentFromRemoteRegion) {
        this.gZipContentFromRemoteRegion = gZipContentFromRemoteRegion;
    }

    public void setRemoteRegionUrlsWithName(Map<String, String> remoteRegionUrlsWithName) {
        this.remoteRegionUrlsWithName = remoteRegionUrlsWithName;
    }

    public void setRemoteRegionUrls(String[] remoteRegionUrls) {
        this.remoteRegionUrls = remoteRegionUrls;
    }

    public void setRemoteRegionAppWhitelist(Map<String, Set<String>> remoteRegionAppWhitelist) {
        this.remoteRegionAppWhitelist = remoteRegionAppWhitelist;
    }

    public void setRemoteRegionRegistryFetchInterval(int remoteRegionRegistryFetchInterval) {
        this.remoteRegionRegistryFetchInterval = remoteRegionRegistryFetchInterval;
    }

    public void setRemoteRegionTrustStore(String remoteRegionTrustStore) {
        this.remoteRegionTrustStore = remoteRegionTrustStore;
    }

    public void setRemoteRegionTrustStorePassword(String remoteRegionTrustStorePassword) {
        this.remoteRegionTrustStorePassword = remoteRegionTrustStorePassword;
    }

    public void setDisableTransparentFallbackToOtherRegion(boolean disableTransparentFallbackToOtherRegion) {
        this.disableTransparentFallbackToOtherRegion = disableTransparentFallbackToOtherRegion;
    }

    public void setBatchReplication(boolean batchReplication) {
        this.batchReplication = batchReplication;
    }

    public void setRateLimiterEnabled(boolean rateLimiterEnabled) {
        this.rateLimiterEnabled = rateLimiterEnabled;
    }

    public void setRateLimiterThrottleStandardClients(boolean rateLimiterThrottleStandardClients) {
        this.rateLimiterThrottleStandardClients = rateLimiterThrottleStandardClients;
    }

    public void setRateLimiterPrivilegedClients(Set<String> rateLimiterPrivilegedClients) {
        this.rateLimiterPrivilegedClients = rateLimiterPrivilegedClients;
    }

    public void setRateLimiterBurstSize(int rateLimiterBurstSize) {
        this.rateLimiterBurstSize = rateLimiterBurstSize;
    }

    public void setRateLimiterRegistryFetchAverageRate(int rateLimiterRegistryFetchAverageRate) {
        this.rateLimiterRegistryFetchAverageRate = rateLimiterRegistryFetchAverageRate;
    }

    public void setRateLimiterFullFetchAverageRate(int rateLimiterFullFetchAverageRate) {
        this.rateLimiterFullFetchAverageRate = rateLimiterFullFetchAverageRate;
    }

    public void setLogIdentityHeaders(boolean logIdentityHeaders) {
        this.logIdentityHeaders = logIdentityHeaders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EurekaServerConfigBean)) {
            return false;
        }
        EurekaServerConfigBean other = (EurekaServerConfigBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$aWSAccessId = this.getAWSAccessId();
        String other$aWSAccessId = other.getAWSAccessId();
        if (this$aWSAccessId == null ? other$aWSAccessId != null : !this$aWSAccessId.equals(other$aWSAccessId)) {
            return false;
        }
        String this$aWSSecretKey = this.getAWSSecretKey();
        String other$aWSSecretKey = other.getAWSSecretKey();
        if (this$aWSSecretKey == null ? other$aWSSecretKey != null : !this$aWSSecretKey.equals(other$aWSSecretKey)) {
            return false;
        }
        if (this.getEIPBindRebindRetries() != other.getEIPBindRebindRetries()) {
            return false;
        }
        if (this.getEIPBindingRetryIntervalMs() != other.getEIPBindingRetryIntervalMs()) {
            return false;
        }
        if (this.isEnableSelfPreservation() != other.isEnableSelfPreservation()) {
            return false;
        }
        if (Double.compare(this.getRenewalPercentThreshold(), other.getRenewalPercentThreshold()) != 0) {
            return false;
        }
        if (this.getRenewalThresholdUpdateIntervalMs() != other.getRenewalThresholdUpdateIntervalMs()) {
            return false;
        }
        if (this.getPeerEurekaNodesUpdateIntervalMs() != other.getPeerEurekaNodesUpdateIntervalMs()) {
            return false;
        }
        if (this.getNumberOfReplicationRetries() != other.getNumberOfReplicationRetries()) {
            return false;
        }
        if (this.getPeerEurekaStatusRefreshTimeIntervalMs() != other.getPeerEurekaStatusRefreshTimeIntervalMs()) {
            return false;
        }
        if (this.getWaitTimeInMsWhenSyncEmpty() != other.getWaitTimeInMsWhenSyncEmpty()) {
            return false;
        }
        if (this.getPeerNodeConnectTimeoutMs() != other.getPeerNodeConnectTimeoutMs()) {
            return false;
        }
        if (this.getPeerNodeReadTimeoutMs() != other.getPeerNodeReadTimeoutMs()) {
            return false;
        }
        if (this.getPeerNodeTotalConnections() != other.getPeerNodeTotalConnections()) {
            return false;
        }
        if (this.getPeerNodeTotalConnectionsPerHost() != other.getPeerNodeTotalConnectionsPerHost()) {
            return false;
        }
        if (this.getPeerNodeConnectionIdleTimeoutSeconds() != other.getPeerNodeConnectionIdleTimeoutSeconds()) {
            return false;
        }
        if (this.getRetentionTimeInMSInDeltaQueue() != other.getRetentionTimeInMSInDeltaQueue()) {
            return false;
        }
        if (this.getDeltaRetentionTimerIntervalInMs() != other.getDeltaRetentionTimerIntervalInMs()) {
            return false;
        }
        if (this.getEvictionIntervalTimerInMs() != other.getEvictionIntervalTimerInMs()) {
            return false;
        }
        if (this.getASGQueryTimeoutMs() != other.getASGQueryTimeoutMs()) {
            return false;
        }
        if (this.getASGUpdateIntervalMs() != other.getASGUpdateIntervalMs()) {
            return false;
        }
        if (this.getResponseCacheAutoExpirationInSeconds() != other.getResponseCacheAutoExpirationInSeconds()) {
            return false;
        }
        if (this.getResponseCacheUpdateIntervalMs() != other.getResponseCacheUpdateIntervalMs()) {
            return false;
        }
        if (this.isDisableDelta() != other.isDisableDelta()) {
            return false;
        }
        if (this.getMaxIdleThreadInMinutesAgeForStatusReplication() != other.getMaxIdleThreadInMinutesAgeForStatusReplication()) {
            return false;
        }
        if (this.getMinThreadsForStatusReplication() != other.getMinThreadsForStatusReplication()) {
            return false;
        }
        if (this.getMaxThreadsForStatusReplication() != other.getMaxThreadsForStatusReplication()) {
            return false;
        }
        if (this.getMaxElementsInStatusReplicationPool() != other.getMaxElementsInStatusReplicationPool()) {
            return false;
        }
        if (this.isSyncWhenTimestampDiffers() != other.isSyncWhenTimestampDiffers()) {
            return false;
        }
        if (this.getRegistrySyncRetries() != other.getRegistrySyncRetries()) {
            return false;
        }
        if (this.getMaxElementsInPeerReplicationPool() != other.getMaxElementsInPeerReplicationPool()) {
            return false;
        }
        if (this.getMaxIdleThreadAgeInMinutesForPeerReplication() != other.getMaxIdleThreadAgeInMinutesForPeerReplication()) {
            return false;
        }
        if (this.getMinThreadsForPeerReplication() != other.getMinThreadsForPeerReplication()) {
            return false;
        }
        if (this.getMaxThreadsForPeerReplication() != other.getMaxThreadsForPeerReplication()) {
            return false;
        }
        if (this.getMaxTimeForReplication() != other.getMaxTimeForReplication()) {
            return false;
        }
        if (this.isPrimeAwsReplicaConnections() != other.isPrimeAwsReplicaConnections()) {
            return false;
        }
        if (this.isDisableDeltaForRemoteRegions() != other.isDisableDeltaForRemoteRegions()) {
            return false;
        }
        if (this.getRemoteRegionConnectTimeoutMs() != other.getRemoteRegionConnectTimeoutMs()) {
            return false;
        }
        if (this.getRemoteRegionReadTimeoutMs() != other.getRemoteRegionReadTimeoutMs()) {
            return false;
        }
        if (this.getRemoteRegionTotalConnections() != other.getRemoteRegionTotalConnections()) {
            return false;
        }
        if (this.getRemoteRegionTotalConnectionsPerHost() != other.getRemoteRegionTotalConnectionsPerHost()) {
            return false;
        }
        if (this.getRemoteRegionConnectionIdleTimeoutSeconds() != other.getRemoteRegionConnectionIdleTimeoutSeconds()) {
            return false;
        }
        if (this.isGZipContentFromRemoteRegion() != other.isGZipContentFromRemoteRegion()) {
            return false;
        }
        Map<String, String> this$remoteRegionUrlsWithName = this.getRemoteRegionUrlsWithName();
        Map<String, String> other$remoteRegionUrlsWithName = other.getRemoteRegionUrlsWithName();
        if (this$remoteRegionUrlsWithName == null ? other$remoteRegionUrlsWithName != null : !((Object)this$remoteRegionUrlsWithName).equals(other$remoteRegionUrlsWithName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRemoteRegionUrls(), other.getRemoteRegionUrls())) {
            return false;
        }
        Map<String, Set<String>> this$remoteRegionAppWhitelist = this.getRemoteRegionAppWhitelist();
        Map<String, Set<String>> other$remoteRegionAppWhitelist = other.getRemoteRegionAppWhitelist();
        if (this$remoteRegionAppWhitelist == null ? other$remoteRegionAppWhitelist != null : !((Object)this$remoteRegionAppWhitelist).equals(other$remoteRegionAppWhitelist)) {
            return false;
        }
        if (this.getRemoteRegionRegistryFetchInterval() != other.getRemoteRegionRegistryFetchInterval()) {
            return false;
        }
        String this$remoteRegionTrustStore = this.getRemoteRegionTrustStore();
        String other$remoteRegionTrustStore = other.getRemoteRegionTrustStore();
        if (this$remoteRegionTrustStore == null ? other$remoteRegionTrustStore != null : !this$remoteRegionTrustStore.equals(other$remoteRegionTrustStore)) {
            return false;
        }
        String this$remoteRegionTrustStorePassword = this.getRemoteRegionTrustStorePassword();
        String other$remoteRegionTrustStorePassword = other.getRemoteRegionTrustStorePassword();
        if (this$remoteRegionTrustStorePassword == null ? other$remoteRegionTrustStorePassword != null : !this$remoteRegionTrustStorePassword.equals(other$remoteRegionTrustStorePassword)) {
            return false;
        }
        if (this.isDisableTransparentFallbackToOtherRegion() != other.isDisableTransparentFallbackToOtherRegion()) {
            return false;
        }
        if (this.isBatchReplication() != other.isBatchReplication()) {
            return false;
        }
        if (this.isRateLimiterEnabled() != other.isRateLimiterEnabled()) {
            return false;
        }
        if (this.isRateLimiterThrottleStandardClients() != other.isRateLimiterThrottleStandardClients()) {
            return false;
        }
        Set<String> this$rateLimiterPrivilegedClients = this.getRateLimiterPrivilegedClients();
        Set<String> other$rateLimiterPrivilegedClients = other.getRateLimiterPrivilegedClients();
        if (this$rateLimiterPrivilegedClients == null ? other$rateLimiterPrivilegedClients != null : !((Object)this$rateLimiterPrivilegedClients).equals(other$rateLimiterPrivilegedClients)) {
            return false;
        }
        if (this.getRateLimiterBurstSize() != other.getRateLimiterBurstSize()) {
            return false;
        }
        if (this.getRateLimiterRegistryFetchAverageRate() != other.getRateLimiterRegistryFetchAverageRate()) {
            return false;
        }
        if (this.getRateLimiterFullFetchAverageRate() != other.getRateLimiterFullFetchAverageRate()) {
            return false;
        }
        return this.isLogIdentityHeaders() == other.isLogIdentityHeaders();
    }

    public boolean canEqual(Object other) {
        return other instanceof EurekaServerConfigBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $aWSAccessId = this.getAWSAccessId();
        result = result * 59 + ($aWSAccessId == null ? 0 : $aWSAccessId.hashCode());
        String $aWSSecretKey = this.getAWSSecretKey();
        result = result * 59 + ($aWSSecretKey == null ? 0 : $aWSSecretKey.hashCode());
        result = result * 59 + this.getEIPBindRebindRetries();
        result = result * 59 + this.getEIPBindingRetryIntervalMs();
        result = result * 59 + (this.isEnableSelfPreservation() ? 79 : 97);
        long $renewalPercentThreshold = Double.doubleToLongBits(this.getRenewalPercentThreshold());
        result = result * 59 + (int)($renewalPercentThreshold >>> 32 ^ $renewalPercentThreshold);
        result = result * 59 + this.getRenewalThresholdUpdateIntervalMs();
        result = result * 59 + this.getPeerEurekaNodesUpdateIntervalMs();
        result = result * 59 + this.getNumberOfReplicationRetries();
        result = result * 59 + this.getPeerEurekaStatusRefreshTimeIntervalMs();
        result = result * 59 + this.getWaitTimeInMsWhenSyncEmpty();
        result = result * 59 + this.getPeerNodeConnectTimeoutMs();
        result = result * 59 + this.getPeerNodeReadTimeoutMs();
        result = result * 59 + this.getPeerNodeTotalConnections();
        result = result * 59 + this.getPeerNodeTotalConnectionsPerHost();
        result = result * 59 + this.getPeerNodeConnectionIdleTimeoutSeconds();
        long $retentionTimeInMSInDeltaQueue = this.getRetentionTimeInMSInDeltaQueue();
        result = result * 59 + (int)($retentionTimeInMSInDeltaQueue >>> 32 ^ $retentionTimeInMSInDeltaQueue);
        long $deltaRetentionTimerIntervalInMs = this.getDeltaRetentionTimerIntervalInMs();
        result = result * 59 + (int)($deltaRetentionTimerIntervalInMs >>> 32 ^ $deltaRetentionTimerIntervalInMs);
        long $evictionIntervalTimerInMs = this.getEvictionIntervalTimerInMs();
        result = result * 59 + (int)($evictionIntervalTimerInMs >>> 32 ^ $evictionIntervalTimerInMs);
        result = result * 59 + this.getASGQueryTimeoutMs();
        long $aSGUpdateIntervalMs = this.getASGUpdateIntervalMs();
        result = result * 59 + (int)($aSGUpdateIntervalMs >>> 32 ^ $aSGUpdateIntervalMs);
        long $responseCacheAutoExpirationInSeconds = this.getResponseCacheAutoExpirationInSeconds();
        result = result * 59 + (int)($responseCacheAutoExpirationInSeconds >>> 32 ^ $responseCacheAutoExpirationInSeconds);
        long $responseCacheUpdateIntervalMs = this.getResponseCacheUpdateIntervalMs();
        result = result * 59 + (int)($responseCacheUpdateIntervalMs >>> 32 ^ $responseCacheUpdateIntervalMs);
        result = result * 59 + (this.isDisableDelta() ? 79 : 97);
        long $maxIdleThreadInMinutesAgeForStatusReplication = this.getMaxIdleThreadInMinutesAgeForStatusReplication();
        result = result * 59 + (int)($maxIdleThreadInMinutesAgeForStatusReplication >>> 32 ^ $maxIdleThreadInMinutesAgeForStatusReplication);
        result = result * 59 + this.getMinThreadsForStatusReplication();
        result = result * 59 + this.getMaxThreadsForStatusReplication();
        result = result * 59 + this.getMaxElementsInStatusReplicationPool();
        result = result * 59 + (this.isSyncWhenTimestampDiffers() ? 79 : 97);
        result = result * 59 + this.getRegistrySyncRetries();
        result = result * 59 + this.getMaxElementsInPeerReplicationPool();
        long $maxIdleThreadAgeInMinutesForPeerReplication = this.getMaxIdleThreadAgeInMinutesForPeerReplication();
        result = result * 59 + (int)($maxIdleThreadAgeInMinutesForPeerReplication >>> 32 ^ $maxIdleThreadAgeInMinutesForPeerReplication);
        result = result * 59 + this.getMinThreadsForPeerReplication();
        result = result * 59 + this.getMaxThreadsForPeerReplication();
        result = result * 59 + this.getMaxTimeForReplication();
        result = result * 59 + (this.isPrimeAwsReplicaConnections() ? 79 : 97);
        result = result * 59 + (this.isDisableDeltaForRemoteRegions() ? 79 : 97);
        result = result * 59 + this.getRemoteRegionConnectTimeoutMs();
        result = result * 59 + this.getRemoteRegionReadTimeoutMs();
        result = result * 59 + this.getRemoteRegionTotalConnections();
        result = result * 59 + this.getRemoteRegionTotalConnectionsPerHost();
        result = result * 59 + this.getRemoteRegionConnectionIdleTimeoutSeconds();
        result = result * 59 + (this.isGZipContentFromRemoteRegion() ? 79 : 97);
        Map<String, String> $remoteRegionUrlsWithName = this.getRemoteRegionUrlsWithName();
        result = result * 59 + ($remoteRegionUrlsWithName == null ? 0 : ((Object)$remoteRegionUrlsWithName).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRemoteRegionUrls());
        Map<String, Set<String>> $remoteRegionAppWhitelist = this.getRemoteRegionAppWhitelist();
        result = result * 59 + ($remoteRegionAppWhitelist == null ? 0 : ((Object)$remoteRegionAppWhitelist).hashCode());
        result = result * 59 + this.getRemoteRegionRegistryFetchInterval();
        String $remoteRegionTrustStore = this.getRemoteRegionTrustStore();
        result = result * 59 + ($remoteRegionTrustStore == null ? 0 : $remoteRegionTrustStore.hashCode());
        String $remoteRegionTrustStorePassword = this.getRemoteRegionTrustStorePassword();
        result = result * 59 + ($remoteRegionTrustStorePassword == null ? 0 : $remoteRegionTrustStorePassword.hashCode());
        result = result * 59 + (this.isDisableTransparentFallbackToOtherRegion() ? 79 : 97);
        result = result * 59 + (this.isBatchReplication() ? 79 : 97);
        result = result * 59 + (this.isRateLimiterEnabled() ? 79 : 97);
        result = result * 59 + (this.isRateLimiterThrottleStandardClients() ? 79 : 97);
        Set<String> $rateLimiterPrivilegedClients = this.getRateLimiterPrivilegedClients();
        result = result * 59 + ($rateLimiterPrivilegedClients == null ? 0 : ((Object)$rateLimiterPrivilegedClients).hashCode());
        result = result * 59 + this.getRateLimiterBurstSize();
        result = result * 59 + this.getRateLimiterRegistryFetchAverageRate();
        result = result * 59 + this.getRateLimiterFullFetchAverageRate();
        result = result * 59 + (this.isLogIdentityHeaders() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "EurekaServerConfigBean(aWSAccessId=" + this.getAWSAccessId() + ", aWSSecretKey=" + this.getAWSSecretKey() + ", eIPBindRebindRetries=" + this.getEIPBindRebindRetries() + ", eIPBindingRetryIntervalMs=" + this.getEIPBindingRetryIntervalMs() + ", enableSelfPreservation=" + this.isEnableSelfPreservation() + ", renewalPercentThreshold=" + this.getRenewalPercentThreshold() + ", renewalThresholdUpdateIntervalMs=" + this.getRenewalThresholdUpdateIntervalMs() + ", peerEurekaNodesUpdateIntervalMs=" + this.getPeerEurekaNodesUpdateIntervalMs() + ", numberOfReplicationRetries=" + this.getNumberOfReplicationRetries() + ", peerEurekaStatusRefreshTimeIntervalMs=" + this.getPeerEurekaStatusRefreshTimeIntervalMs() + ", waitTimeInMsWhenSyncEmpty=" + this.getWaitTimeInMsWhenSyncEmpty() + ", peerNodeConnectTimeoutMs=" + this.getPeerNodeConnectTimeoutMs() + ", peerNodeReadTimeoutMs=" + this.getPeerNodeReadTimeoutMs() + ", peerNodeTotalConnections=" + this.getPeerNodeTotalConnections() + ", peerNodeTotalConnectionsPerHost=" + this.getPeerNodeTotalConnectionsPerHost() + ", peerNodeConnectionIdleTimeoutSeconds=" + this.getPeerNodeConnectionIdleTimeoutSeconds() + ", retentionTimeInMSInDeltaQueue=" + this.getRetentionTimeInMSInDeltaQueue() + ", deltaRetentionTimerIntervalInMs=" + this.getDeltaRetentionTimerIntervalInMs() + ", evictionIntervalTimerInMs=" + this.getEvictionIntervalTimerInMs() + ", aSGQueryTimeoutMs=" + this.getASGQueryTimeoutMs() + ", aSGUpdateIntervalMs=" + this.getASGUpdateIntervalMs() + ", responseCacheAutoExpirationInSeconds=" + this.getResponseCacheAutoExpirationInSeconds() + ", responseCacheUpdateIntervalMs=" + this.getResponseCacheUpdateIntervalMs() + ", disableDelta=" + this.isDisableDelta() + ", maxIdleThreadInMinutesAgeForStatusReplication=" + this.getMaxIdleThreadInMinutesAgeForStatusReplication() + ", minThreadsForStatusReplication=" + this.getMinThreadsForStatusReplication() + ", maxThreadsForStatusReplication=" + this.getMaxThreadsForStatusReplication() + ", maxElementsInStatusReplicationPool=" + this.getMaxElementsInStatusReplicationPool() + ", syncWhenTimestampDiffers=" + this.isSyncWhenTimestampDiffers() + ", registrySyncRetries=" + this.getRegistrySyncRetries() + ", maxElementsInPeerReplicationPool=" + this.getMaxElementsInPeerReplicationPool() + ", maxIdleThreadAgeInMinutesForPeerReplication=" + this.getMaxIdleThreadAgeInMinutesForPeerReplication() + ", minThreadsForPeerReplication=" + this.getMinThreadsForPeerReplication() + ", maxThreadsForPeerReplication=" + this.getMaxThreadsForPeerReplication() + ", maxTimeForReplication=" + this.getMaxTimeForReplication() + ", primeAwsReplicaConnections=" + this.isPrimeAwsReplicaConnections() + ", disableDeltaForRemoteRegions=" + this.isDisableDeltaForRemoteRegions() + ", remoteRegionConnectTimeoutMs=" + this.getRemoteRegionConnectTimeoutMs() + ", remoteRegionReadTimeoutMs=" + this.getRemoteRegionReadTimeoutMs() + ", remoteRegionTotalConnections=" + this.getRemoteRegionTotalConnections() + ", remoteRegionTotalConnectionsPerHost=" + this.getRemoteRegionTotalConnectionsPerHost() + ", remoteRegionConnectionIdleTimeoutSeconds=" + this.getRemoteRegionConnectionIdleTimeoutSeconds() + ", gZipContentFromRemoteRegion=" + this.isGZipContentFromRemoteRegion() + ", remoteRegionUrlsWithName=" + this.getRemoteRegionUrlsWithName() + ", remoteRegionUrls=" + Arrays.deepToString(this.getRemoteRegionUrls()) + ", remoteRegionAppWhitelist=" + this.getRemoteRegionAppWhitelist() + ", remoteRegionRegistryFetchInterval=" + this.getRemoteRegionRegistryFetchInterval() + ", remoteRegionTrustStore=" + this.getRemoteRegionTrustStore() + ", remoteRegionTrustStorePassword=" + this.getRemoteRegionTrustStorePassword() + ", disableTransparentFallbackToOtherRegion=" + this.isDisableTransparentFallbackToOtherRegion() + ", batchReplication=" + this.isBatchReplication() + ", rateLimiterEnabled=" + this.isRateLimiterEnabled() + ", rateLimiterThrottleStandardClients=" + this.isRateLimiterThrottleStandardClients() + ", rateLimiterPrivilegedClients=" + this.getRateLimiterPrivilegedClients() + ", rateLimiterBurstSize=" + this.getRateLimiterBurstSize() + ", rateLimiterRegistryFetchAverageRate=" + this.getRateLimiterRegistryFetchAverageRate() + ", rateLimiterFullFetchAverageRate=" + this.getRateLimiterFullFetchAverageRate() + ", logIdentityHeaders=" + this.isLogIdentityHeaders() + ")";
    }
}

