/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.niws.client.http.RestClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;

public class RibbonClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final SpringClientFactory clientFactory;
    private LoadBalancerClient loadBalancer;

    public RibbonClientHttpRequestFactory(SpringClientFactory clientFactory, LoadBalancerClient loadBalancer) {
        this.clientFactory = clientFactory;
        this.loadBalancer = loadBalancer;
    }

    public ClientHttpRequest createRequest(URI originalUri, HttpMethod httpMethod) throws IOException {
        String serviceId = originalUri.getHost();
        ServiceInstance instance = this.loadBalancer.choose(serviceId);
        if (instance == null) {
            throw new IllegalStateException("No instances available for " + serviceId);
        }
        URI uri = this.loadBalancer.reconstructURI(instance, originalUri);
        IClientConfig clientConfig = this.clientFactory.getClientConfig(instance.getServiceId());
        RestClient client = this.clientFactory.getClient(instance.getServiceId(), RestClient.class);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).verb(HttpRequest.Verb.valueOf((String)httpMethod.name())).build();
        return new RibbonHttpRequest(request, client, clientConfig);
    }

    public class RibbonHttpResponse
    extends AbstractClientHttpResponse {
        private HttpResponse response;
        private HttpHeaders httpHeaders;

        public RibbonHttpResponse(HttpResponse response) {
            this.response = response;
            this.httpHeaders = new HttpHeaders();
            List headers = response.getHttpHeaders().getAllHeaders();
            for (Map.Entry header : headers) {
                this.httpHeaders.add((String)header.getKey(), (String)header.getValue());
            }
        }

        public InputStream getBody() throws IOException {
            return this.response.getInputStream();
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public int getRawStatusCode() throws IOException {
            return this.response.getStatus();
        }

        public String getStatusText() throws IOException {
            return HttpStatus.valueOf((int)this.response.getStatus()).name();
        }

        public void close() {
            this.response.close();
        }
    }

    public class RibbonHttpRequest
    extends AbstractClientHttpRequest {
        private HttpRequest request;
        private RestClient client;
        private IClientConfig config;

        public RibbonHttpRequest(HttpRequest request, RestClient client, IClientConfig config) {
            this.request = request;
            this.client = client;
            this.config = config;
            request.getHeaders().putAll(this.getHeaders());
        }

        public HttpMethod getMethod() {
            return HttpMethod.valueOf((String)this.request.getVerb().name());
        }

        public URI getURI() {
            return this.request.getUri();
        }

        protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
            throw new RuntimeException("Not implemented");
        }

        protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
            return (ClientHttpResponse)RibbonClientHttpRequestFactory.this.loadBalancer.execute(this.config.getClientName(), (LoadBalancerRequest)new LoadBalancerRequest<ClientHttpResponse>(){

                public ClientHttpResponse apply(ServiceInstance instance) throws Exception {
                    HttpResponse response = RibbonHttpRequest.this.client.execute(RibbonHttpRequest.this.request, RibbonHttpRequest.this.config);
                    return new RibbonHttpResponse(response);
                }
            });
        }
    }
}

