/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.servo;

import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.BaseMetricObserver;
import com.netflix.servo.publish.BasicMetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.publish.MonitorRegistryMetricPoller;
import com.netflix.servo.publish.PollRunnable;
import com.netflix.servo.publish.PollScheduler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;

public class ServoMetricCollector
implements DisposableBean {
    private static final Log log = LogFactory.getLog(ServoMetricCollector.class);

    public ServoMetricCollector(MetricWriter metrics) {
        ArrayList<ServoMetricObserver> observers = new ArrayList<ServoMetricObserver>();
        observers.add(new ServoMetricObserver(metrics));
        PollRunnable task = new PollRunnable((MetricPoller)new MonitorRegistryMetricPoller(), BasicMetricFilter.MATCH_ALL, true, observers);
        if (!PollScheduler.getInstance().isStarted()) {
            try {
                PollScheduler.getInstance().start();
            }
            catch (Exception e) {
                log.error((Object)"Could not start servo metrics poller", (Throwable)e);
                return;
            }
        }
        PollScheduler.getInstance().addPoller(task, 5L, TimeUnit.SECONDS);
    }

    public void destroy() throws Exception {
        log.info((Object)"Stopping Servo PollScheduler");
        if (PollScheduler.getInstance().isStarted()) {
            try {
                PollScheduler.getInstance().stop();
            }
            catch (Exception e) {
                log.error((Object)"Could not stop servo metrics poller", (Throwable)e);
            }
        }
    }

    private static final class ServoMetricObserver
    extends BaseMetricObserver {
        private final MetricWriter metrics;

        public ServoMetricObserver(MetricWriter metrics) {
            super("spring-boot");
            this.metrics = metrics;
        }

        public void updateImpl(List<com.netflix.servo.Metric> servoMetrics) {
            for (com.netflix.servo.Metric servoMetric : servoMetrics) {
                MonitorConfig config = servoMetric.getConfig();
                String type = config.getTags().getValue("type");
                String key = (type + ".servo." + config.getName()).toLowerCase();
                if (!servoMetric.hasNumberValue()) continue;
                this.metrics.set(new Metric(key, servoMetric.getNumberValue(), new Date(servoMetric.getTimestamp())));
            }
        }
    }
}

