/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.EurekaJerseyClient;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.DiscoveryManagerInitializer;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EurekaHealthIndicator;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaClientConfig.class})
@ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
public class EurekaDiscoveryClientConfiguration
implements SmartLifecycle,
Ordered {
    private static final Log log = LogFactory.getLog(EurekaDiscoveryClientConfiguration.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private int order = 0;
    private AtomicInteger port = new AtomicInteger(0);
    @Autowired
    private EurekaInstanceConfigBean instanceConfig;
    @Autowired(required=false)
    private HealthCheckHandler healthCheckHandler;
    @Autowired
    private DiscoveryManagerInitializer discoveryManagerInitializer;
    @Autowired
    private ApplicationContext context;

    @PreDestroy
    public void close() {
        this.closeDiscoveryClientJersey();
        log.info((Object)("Removing application " + this.instanceConfig.getAppname() + " from eureka"));
        DiscoveryManager.getInstance().shutdownComponent();
    }

    private void closeDiscoveryClientJersey() {
        log.info((Object)"Closing DiscoveryClient.jerseyClient");
        Field jerseyClientField = ReflectionUtils.findField(DiscoveryClient.class, (String)"discoveryJerseyClient", EurekaJerseyClient.JerseyClient.class);
        if (jerseyClientField != null) {
            try {
                Object obj;
                jerseyClientField.setAccessible(true);
                if (DiscoveryManager.getInstance() != null && DiscoveryManager.getInstance().getDiscoveryClient() != null && (obj = jerseyClientField.get(DiscoveryManager.getInstance().getDiscoveryClient())) != null) {
                    EurekaJerseyClient.JerseyClient jerseyClient = (EurekaJerseyClient.JerseyClient)obj;
                    jerseyClient.destroyResources();
                }
            }
            catch (Exception ex) {
                log.error((Object)"Error closing DiscoveryClient.jerseyClient", (Throwable)ex);
            }
        }
    }

    public void start() {
        if (this.port.get() != 0 && this.instanceConfig.getNonSecurePort() == 0) {
            this.instanceConfig.setNonSecurePort(this.port.get());
        }
        if (!this.running.get() && this.instanceConfig.getNonSecurePort() > 0) {
            this.discoveryManagerInitializer.init();
            log.info((Object)("Registering application " + this.instanceConfig.getAppname() + " with eureka with status " + this.instanceConfig.getInitialStatus()));
            ApplicationInfoManager.getInstance().setInstanceStatus(this.instanceConfig.getInitialStatus());
            if (this.healthCheckHandler != null) {
                DiscoveryManager.getInstance().getDiscoveryClient().registerHealthCheck(this.healthCheckHandler);
            }
            this.context.publishEvent((ApplicationEvent)new InstanceRegisteredEvent((Object)this, (Object)this.instanceConfig));
            this.running.set(true);
        }
    }

    public void stop() {
        log.info((Object)("Unregistering application " + this.instanceConfig.getAppname() + " with eureka with status OUT_OF_SERVICE"));
        if (ApplicationInfoManager.getInstance().getInfo() != null) {
            ApplicationInfoManager.getInstance().setInstanceStatus(InstanceInfo.InstanceStatus.OUT_OF_SERVICE);
        }
        this.running.set(false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
    }

    public int getOrder() {
        return this.order;
    }

    @Bean
    @Lazy
    @Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnMissingBean(value={DiscoveryClient.class})
    public DiscoveryClient eurekaDiscoveryClient() {
        return DiscoveryManager.getInstance().getDiscoveryClient();
    }

    @Bean
    public org.springframework.cloud.client.discovery.DiscoveryClient discoveryClient() {
        return new EurekaDiscoveryClient();
    }

    @Bean
    protected ApplicationListener<EmbeddedServletContainerInitializedEvent> containerPortInitializer() {
        return new ApplicationListener<EmbeddedServletContainerInitializedEvent>(){

            public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
                EurekaDiscoveryClientConfiguration.this.port.compareAndSet(0, event.getEmbeddedServletContainer().getPort());
                EurekaDiscoveryClientConfiguration.this.start();
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    @ConditionalOnBean(value={MetricReader.class})
    protected static class EurekaHealthIndicatorConfiguration {
        protected EurekaHealthIndicatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public EurekaHealthIndicator eurekaHealthIndicator(DiscoveryClient eurekaDiscoveryClient, MetricReader metrics, EurekaInstanceConfig config) {
            return new EurekaHealthIndicator(eurekaDiscoveryClient, metrics, config);
        }
    }

    @Configuration
    protected static class DiscoveryManagerInitializerConfiguration {
        protected DiscoveryManagerInitializerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={DiscoveryManagerInitializer.class})
        public DiscoveryManagerInitializer discoveryManagerInitializer() {
            return new DiscoveryManagerInitializer();
        }
    }
}

