/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import feign.ribbon.LBClient;
import feign.ribbon.LBClientFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;

public class SpringLBClientFactory
implements LBClientFactory {
    private final SpringClientFactory factory;

    public SpringLBClientFactory(SpringClientFactory factory) {
        this.factory = factory;
    }

    public LBClient create(String clientName) {
        IClientConfig config = this.factory.getClientConfig(clientName);
        ILoadBalancer lb = this.factory.getLoadBalancer(clientName);
        return LBClient.create((ILoadBalancer)lb, (IClientConfig)config);
    }
}

