/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.IClient;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.cloud.netflix.ribbon.RibbonClientSpecification;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class SpringClientFactory
implements DisposableBean,
ApplicationContextAware {
    private Map<String, AnnotationConfigApplicationContext> contexts = new ConcurrentHashMap<String, AnnotationConfigApplicationContext>();
    private Map<String, RibbonClientSpecification> configurations = new ConcurrentHashMap<String, RibbonClientSpecification>();
    private ApplicationContext parent;

    public void setApplicationContext(ApplicationContext parent) throws BeansException {
        this.parent = parent;
    }

    public void setConfigurations(List<RibbonClientSpecification> configurations) {
        for (RibbonClientSpecification client : configurations) {
            this.configurations.put(client.getName(), client);
        }
    }

    public void destroy() {
        Collection<AnnotationConfigApplicationContext> values = this.contexts.values();
        this.contexts.clear();
        for (AnnotationConfigApplicationContext context : values) {
            context.close();
        }
    }

    public <C extends IClient<?, ?>> C getClient(String name, Class<C> clientClass) {
        return (C)((IClient)this.getInstance(name, clientClass));
    }

    public ILoadBalancer getLoadBalancer(String name) {
        return this.getInstance(name, ILoadBalancer.class);
    }

    public IClientConfig getClientConfig(String name) {
        return this.getInstance(name, IClientConfig.class);
    }

    public RibbonLoadBalancerContext getLoadBalancerContext(String serviceId) {
        return this.getInstance(serviceId, RibbonLoadBalancerContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnnotationConfigApplicationContext getContext(String name) {
        if (!this.contexts.containsKey(name)) {
            Map<String, AnnotationConfigApplicationContext> map = this.contexts;
            synchronized (map) {
                if (!this.contexts.containsKey(name)) {
                    this.contexts.put(name, this.createContext(name));
                }
            }
        }
        return this.contexts.get(name);
    }

    private AnnotationConfigApplicationContext createContext(String name) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        if (this.configurations.containsKey(name)) {
            for (Class<?> configuration : this.configurations.get(name).getConfiguration()) {
                context.register(new Class[]{configuration});
            }
        }
        for (Map.Entry<String, RibbonClientSpecification> entry : this.configurations.entrySet()) {
            if (!entry.getKey().startsWith("default.")) continue;
            for (Class<?> configuration : entry.getValue().getConfiguration()) {
                context.register(new Class[]{configuration});
            }
        }
        context.register(new Class[]{PropertyPlaceholderAutoConfiguration.class, RibbonClientConfiguration.class});
        context.getEnvironment().getPropertySources().addFirst((PropertySource)new MapPropertySource("ribbon", Collections.singletonMap("ribbon.client.name", name)));
        if (this.parent != null) {
            context.setParent(this.parent);
        }
        context.refresh();
        return context;
    }

    private <C> C instantiateWithConfig(AnnotationConfigApplicationContext context, Class<C> clazz, IClientConfig config) {
        Object result = null;
        if (IClientConfigAware.class.isAssignableFrom(clazz)) {
            IClientConfigAware value;
            IClientConfigAware obj = (IClientConfigAware)BeanUtils.instantiate(clazz);
            obj.initWithNiwsConfig(config);
            result = value = obj;
        } else {
            try {
                result = clazz.getConstructor(IClientConfig.class) != null ? clazz.getConstructor(IClientConfig.class).newInstance(config) : BeanUtils.instantiate(clazz);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        context.getAutowireCapableBeanFactory().autowireBean(result);
        return (C)result;
    }

    private <C> C getInstance(String name, Class<C> type) {
        AnnotationConfigApplicationContext context = this.getContext(name);
        if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, type).length > 0) {
            return (C)context.getBean(type);
        }
        IClientConfig config = this.getInstance(name, IClientConfig.class);
        return this.instantiateWithConfig(context, type, config);
    }
}

