/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.client.ClientException;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.niws.client.http.RestClient;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommand;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class RibbonRoutingFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(RibbonRoutingFilter.class);
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private SpringClientFactory clientFactory;
    private ProxyRequestHelper helper;

    public RibbonRoutingFilter(ProxyRequestHelper helper, SpringClientFactory clientFactory) {
        this.helper = helper;
        this.clientFactory = clientFactory;
    }

    public RibbonRoutingFilter(SpringClientFactory clientFactory) {
        this(new ProxyRequestHelper(), clientFactory);
    }

    public String filterType() {
        return "route";
    }

    public int filterOrder() {
        return 10;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.getRouteHost() == null && ctx.get((Object)"serviceId") != null && ctx.sendZuulResponse();
    }

    public Object run() {
        RequestContext context = RequestContext.getCurrentContext();
        HttpServletRequest request = context.getRequest();
        MultiValueMap<String, String> headers = this.helper.buildZuulRequestHeaders(request);
        MultiValueMap<String, String> params = this.helper.buildZuulRequestQueryParams(request);
        HttpRequest.Verb verb = this.getVerb(request);
        InputStream requestEntity = this.getRequestBody(request);
        String serviceId = (String)context.get((Object)"serviceId");
        Boolean retryable = (Boolean)context.get((Object)"retryable");
        RestClient restClient = this.clientFactory.getClient(serviceId, RestClient.class);
        String uri = request.getRequestURI();
        if (context.get((Object)"requestURI") != null) {
            uri = (String)context.get((Object)"requestURI");
        }
        uri = uri.replace("//", "/");
        String service = (String)context.get((Object)"serviceId");
        try {
            HttpResponse response = this.forward(restClient, service, verb, uri, retryable, headers, params, requestEntity);
            this.setResponse(response);
            return response;
        }
        catch (Exception ex) {
            context.set("error.status_code", (Object)500);
            context.set("error.exception", (Object)ex);
            return null;
        }
    }

    private HttpResponse forward(RestClient restClient, String service, HttpRequest.Verb verb, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws Exception {
        Map<String, Object> info = this.helper.debug(verb.verb(), uri, headers, params, requestEntity);
        RibbonCommand command = new RibbonCommand(service, restClient, verb, uri, retryable, headers, params, requestEntity);
        try {
            HttpResponse response = (HttpResponse)command.execute();
            this.helper.appendDebug(info, response.getStatus(), this.revertHeaders(response.getHeaders()));
            return response;
        }
        catch (HystrixRuntimeException ex) {
            info.put("status", "500");
            if (ex.getFallbackException() != null && ex.getFallbackException().getCause() != null && ex.getFallbackException().getCause() instanceof ClientException) {
                ClientException cause = (ClientException)ex.getFallbackException().getCause();
                throw new ZuulException((Throwable)cause, "Forwarding error", 500, cause.getErrorType().toString());
            }
            throw new ZuulException((Throwable)ex, "Forwarding error", 500, ex.getFailureType().toString());
        }
    }

    private MultiValueMap<String, String> revertHeaders(Map<String, Collection<String>> headers) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
            map.put((Object)entry.getKey(), new ArrayList<String>(entry.getValue()));
        }
        return map;
    }

    private InputStream getRequestBody(HttpServletRequest request) {
        InputStream requestEntity = null;
        if (request.getMethod().equals("DELETE")) {
            return null;
        }
        try {
            requestEntity = (InputStream)RequestContext.getCurrentContext().get((Object)"requestEntity");
            if (requestEntity == null) {
                requestEntity = request.getInputStream();
            }
        }
        catch (IOException ex) {
            log.error((Object)"Error during getRequestBody", (Throwable)ex);
        }
        return requestEntity;
    }

    private HttpRequest.Verb getVerb(HttpServletRequest request) {
        String sMethod = request.getMethod();
        return this.getVerb(sMethod);
    }

    private HttpRequest.Verb getVerb(String sMethod) {
        if (sMethod == null) {
            return HttpRequest.Verb.GET;
        }
        try {
            return HttpRequest.Verb.valueOf((String)sMethod.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return HttpRequest.Verb.GET;
        }
    }

    private void setResponse(HttpResponse resp) throws ClientException, IOException {
        this.helper.setResponse(resp.getStatus(), !resp.hasEntity() ? null : resp.getInputStream(), this.revertHeaders(resp.getHeaders()));
    }
}

