/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.post;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ReflectionUtils;

public class SendErrorFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(SendErrorFilter.class);
    protected static final String SEND_ERROR_FILTER_RAN = "sendErrorFilter.ran";
    @Value(value="${error.path:/error}")
    private String errorPath;

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.containsKey((Object)"error.status_code") && !ctx.getBoolean(SEND_ERROR_FILTER_RAN, false);
    }

    public Object run() {
        try {
            RequestContext ctx = RequestContext.getCurrentContext();
            int statusCode = (Integer)ctx.get((Object)"error.status_code");
            if (ctx.containsKey((Object)"error.exception")) {
                Object e = ctx.get((Object)"error.exception");
                log.warn((Object)"Error during filtering", (Throwable)Throwable.class.cast(e));
                ctx.getRequest().setAttribute("javax.servlet.error.exception", e);
            }
            ctx.getRequest().setAttribute("javax.servlet.error.status_code", (Object)statusCode);
            RequestDispatcher dispatcher = ctx.getRequest().getRequestDispatcher(this.errorPath);
            if (dispatcher != null) {
                ctx.set(SEND_ERROR_FILTER_RAN, (Object)true);
                if (!ctx.getResponse().isCommitted()) {
                    dispatcher.forward((ServletRequest)ctx.getRequest(), (ServletResponse)ctx.getResponse());
                }
            }
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
        return null;
    }

    public void setErrorPath(String errorPath) {
        this.errorPath = errorPath;
    }
}

