/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.config;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClientConfiguration;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

@ConditionalOnBean(value={EurekaDiscoveryClientConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"}, matchIfMissing=false)
@Configuration
public class DiscoveryClientConfigServiceAutoConfiguration
implements ApplicationListener<RefreshScopeRefreshedEvent> {
    @Autowired
    private EurekaClientConfig clientConfig;
    @Autowired
    private EurekaInstanceConfig instanceConfig;
    @Autowired
    private EurekaDiscoveryClientConfiguration lifecycle;

    @PostConstruct
    public void init() {
        this.lifecycle.stop();
        if (DiscoveryManager.getInstance().getDiscoveryClient() != null) {
            DiscoveryManager.getInstance().getDiscoveryClient().shutdown();
        }
        ApplicationInfoManager.getInstance().initComponent(this.instanceConfig);
        DiscoveryManager.getInstance().initComponent(this.instanceConfig, this.clientConfig);
        this.lifecycle.start();
    }

    public void onApplicationEvent(RefreshScopeRefreshedEvent arg0) {
        this.init();
    }
}

