/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.discovery.EurekaClientConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="eureka.client")
public class EurekaClientConfigBean
implements EurekaClientConfig {
    public static final String DEFAULT_URL = "http://localhost:8761/eureka/";
    public static final String DEFAULT_ZONE = "defaultZone";
    private static final int MINUTES = 60;
    private boolean enabled = true;
    private int registryFetchIntervalSeconds = 30;
    private int instanceInfoReplicationIntervalSeconds = 30;
    private int initialInstanceInfoReplicationIntervalSeconds = 40;
    private int eurekaServiceUrlPollIntervalSeconds = 300;
    private String proxyPort;
    private String proxyHost;
    private String proxyUserName;
    private String proxyPassword;
    private int eurekaServerReadTimeoutSeconds = 8;
    private int eurekaServerConnectTimeoutSeconds = 5;
    private String backupRegistryImpl;
    private int eurekaServerTotalConnections = 200;
    private int eurekaServerTotalConnectionsPerHost = 50;
    private String eurekaServerURLContext;
    private String eurekaServerPort;
    private String eurekaServerDNSName;
    private String region = "us-east-1";
    private int eurekaConnectionIdleTimeoutSeconds = 30;
    private String registryRefreshSingleVipAddress;
    private int heartbeatExecutorThreadPoolSize = 2;
    private int heartbeatExecutorExponentialBackOffBound = 10;
    private int cacheRefreshExecutorThreadPoolSize = 2;
    private int cacheRefreshExecutorExponentialBackOffBound = 10;
    private Map<String, String> serviceUrl = new HashMap<String, String>();
    private boolean gZipContent;
    private boolean useDnsForFetchingServiceUrls;
    private boolean registerWithEureka;
    private boolean preferSameZoneEureka;
    private boolean logDeltaDiff;
    private boolean disableDelta;
    private String fetchRemoteRegionsRegistry;
    private Map<String, String> availabilityZones;
    private boolean filterOnlyUpInstances;
    private boolean fetchRegistry;
    private String dollarReplacement;
    private String escapeCharReplacement;

    public boolean shouldGZipContent() {
        return this.gZipContent;
    }

    public boolean shouldUseDnsForFetchingServiceUrls() {
        return this.useDnsForFetchingServiceUrls;
    }

    public boolean shouldRegisterWithEureka() {
        return this.registerWithEureka;
    }

    public boolean shouldPreferSameZoneEureka() {
        return this.preferSameZoneEureka;
    }

    public boolean shouldLogDeltaDiff() {
        return this.logDeltaDiff;
    }

    public boolean shouldDisableDelta() {
        return this.disableDelta;
    }

    public String fetchRegistryForRemoteRegions() {
        return this.fetchRemoteRegionsRegistry;
    }

    public String[] getAvailabilityZones(String region) {
        String value = this.availabilityZones.get(region);
        if (value == null) {
            value = DEFAULT_ZONE;
        }
        return value.split(",");
    }

    public List<String> getEurekaServerServiceUrls(String myZone) {
        String serviceUrls = this.serviceUrl.get(myZone);
        if (serviceUrls == null || serviceUrls.isEmpty()) {
            serviceUrls = this.serviceUrl.get(DEFAULT_ZONE);
        }
        if (serviceUrls != null) {
            return Arrays.asList(serviceUrls.split(","));
        }
        return new ArrayList<String>();
    }

    public boolean shouldFilterOnlyUpInstances() {
        return this.filterOnlyUpInstances;
    }

    public boolean shouldFetchRegistry() {
        return this.fetchRegistry;
    }

    public EurekaClientConfigBean() {
        this.serviceUrl.put(DEFAULT_ZONE, DEFAULT_URL);
        this.gZipContent = true;
        this.useDnsForFetchingServiceUrls = false;
        this.registerWithEureka = true;
        this.preferSameZoneEureka = true;
        this.availabilityZones = new HashMap<String, String>();
        this.filterOnlyUpInstances = true;
        this.fetchRegistry = true;
        this.dollarReplacement = "_-";
        this.escapeCharReplacement = "__";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getRegistryFetchIntervalSeconds() {
        return this.registryFetchIntervalSeconds;
    }

    public int getInstanceInfoReplicationIntervalSeconds() {
        return this.instanceInfoReplicationIntervalSeconds;
    }

    public int getInitialInstanceInfoReplicationIntervalSeconds() {
        return this.initialInstanceInfoReplicationIntervalSeconds;
    }

    public int getEurekaServiceUrlPollIntervalSeconds() {
        return this.eurekaServiceUrlPollIntervalSeconds;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getEurekaServerReadTimeoutSeconds() {
        return this.eurekaServerReadTimeoutSeconds;
    }

    public int getEurekaServerConnectTimeoutSeconds() {
        return this.eurekaServerConnectTimeoutSeconds;
    }

    public String getBackupRegistryImpl() {
        return this.backupRegistryImpl;
    }

    public int getEurekaServerTotalConnections() {
        return this.eurekaServerTotalConnections;
    }

    public int getEurekaServerTotalConnectionsPerHost() {
        return this.eurekaServerTotalConnectionsPerHost;
    }

    public String getEurekaServerURLContext() {
        return this.eurekaServerURLContext;
    }

    public String getEurekaServerPort() {
        return this.eurekaServerPort;
    }

    public String getEurekaServerDNSName() {
        return this.eurekaServerDNSName;
    }

    public String getRegion() {
        return this.region;
    }

    public int getEurekaConnectionIdleTimeoutSeconds() {
        return this.eurekaConnectionIdleTimeoutSeconds;
    }

    public String getRegistryRefreshSingleVipAddress() {
        return this.registryRefreshSingleVipAddress;
    }

    public int getHeartbeatExecutorThreadPoolSize() {
        return this.heartbeatExecutorThreadPoolSize;
    }

    public int getHeartbeatExecutorExponentialBackOffBound() {
        return this.heartbeatExecutorExponentialBackOffBound;
    }

    public int getCacheRefreshExecutorThreadPoolSize() {
        return this.cacheRefreshExecutorThreadPoolSize;
    }

    public int getCacheRefreshExecutorExponentialBackOffBound() {
        return this.cacheRefreshExecutorExponentialBackOffBound;
    }

    public Map<String, String> getServiceUrl() {
        return this.serviceUrl;
    }

    public boolean isGZipContent() {
        return this.gZipContent;
    }

    public boolean isUseDnsForFetchingServiceUrls() {
        return this.useDnsForFetchingServiceUrls;
    }

    public boolean isRegisterWithEureka() {
        return this.registerWithEureka;
    }

    public boolean isPreferSameZoneEureka() {
        return this.preferSameZoneEureka;
    }

    public boolean isLogDeltaDiff() {
        return this.logDeltaDiff;
    }

    public boolean isDisableDelta() {
        return this.disableDelta;
    }

    public String getFetchRemoteRegionsRegistry() {
        return this.fetchRemoteRegionsRegistry;
    }

    public Map<String, String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public boolean isFilterOnlyUpInstances() {
        return this.filterOnlyUpInstances;
    }

    public boolean isFetchRegistry() {
        return this.fetchRegistry;
    }

    public String getDollarReplacement() {
        return this.dollarReplacement;
    }

    public String getEscapeCharReplacement() {
        return this.escapeCharReplacement;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRegistryFetchIntervalSeconds(int registryFetchIntervalSeconds) {
        this.registryFetchIntervalSeconds = registryFetchIntervalSeconds;
    }

    public void setInstanceInfoReplicationIntervalSeconds(int instanceInfoReplicationIntervalSeconds) {
        this.instanceInfoReplicationIntervalSeconds = instanceInfoReplicationIntervalSeconds;
    }

    public void setInitialInstanceInfoReplicationIntervalSeconds(int initialInstanceInfoReplicationIntervalSeconds) {
        this.initialInstanceInfoReplicationIntervalSeconds = initialInstanceInfoReplicationIntervalSeconds;
    }

    public void setEurekaServiceUrlPollIntervalSeconds(int eurekaServiceUrlPollIntervalSeconds) {
        this.eurekaServiceUrlPollIntervalSeconds = eurekaServiceUrlPollIntervalSeconds;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setEurekaServerReadTimeoutSeconds(int eurekaServerReadTimeoutSeconds) {
        this.eurekaServerReadTimeoutSeconds = eurekaServerReadTimeoutSeconds;
    }

    public void setEurekaServerConnectTimeoutSeconds(int eurekaServerConnectTimeoutSeconds) {
        this.eurekaServerConnectTimeoutSeconds = eurekaServerConnectTimeoutSeconds;
    }

    public void setBackupRegistryImpl(String backupRegistryImpl) {
        this.backupRegistryImpl = backupRegistryImpl;
    }

    public void setEurekaServerTotalConnections(int eurekaServerTotalConnections) {
        this.eurekaServerTotalConnections = eurekaServerTotalConnections;
    }

    public void setEurekaServerTotalConnectionsPerHost(int eurekaServerTotalConnectionsPerHost) {
        this.eurekaServerTotalConnectionsPerHost = eurekaServerTotalConnectionsPerHost;
    }

    public void setEurekaServerURLContext(String eurekaServerURLContext) {
        this.eurekaServerURLContext = eurekaServerURLContext;
    }

    public void setEurekaServerPort(String eurekaServerPort) {
        this.eurekaServerPort = eurekaServerPort;
    }

    public void setEurekaServerDNSName(String eurekaServerDNSName) {
        this.eurekaServerDNSName = eurekaServerDNSName;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setEurekaConnectionIdleTimeoutSeconds(int eurekaConnectionIdleTimeoutSeconds) {
        this.eurekaConnectionIdleTimeoutSeconds = eurekaConnectionIdleTimeoutSeconds;
    }

    public void setRegistryRefreshSingleVipAddress(String registryRefreshSingleVipAddress) {
        this.registryRefreshSingleVipAddress = registryRefreshSingleVipAddress;
    }

    public void setHeartbeatExecutorThreadPoolSize(int heartbeatExecutorThreadPoolSize) {
        this.heartbeatExecutorThreadPoolSize = heartbeatExecutorThreadPoolSize;
    }

    public void setHeartbeatExecutorExponentialBackOffBound(int heartbeatExecutorExponentialBackOffBound) {
        this.heartbeatExecutorExponentialBackOffBound = heartbeatExecutorExponentialBackOffBound;
    }

    public void setCacheRefreshExecutorThreadPoolSize(int cacheRefreshExecutorThreadPoolSize) {
        this.cacheRefreshExecutorThreadPoolSize = cacheRefreshExecutorThreadPoolSize;
    }

    public void setCacheRefreshExecutorExponentialBackOffBound(int cacheRefreshExecutorExponentialBackOffBound) {
        this.cacheRefreshExecutorExponentialBackOffBound = cacheRefreshExecutorExponentialBackOffBound;
    }

    public void setServiceUrl(Map<String, String> serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setGZipContent(boolean gZipContent) {
        this.gZipContent = gZipContent;
    }

    public void setUseDnsForFetchingServiceUrls(boolean useDnsForFetchingServiceUrls) {
        this.useDnsForFetchingServiceUrls = useDnsForFetchingServiceUrls;
    }

    public void setRegisterWithEureka(boolean registerWithEureka) {
        this.registerWithEureka = registerWithEureka;
    }

    public void setPreferSameZoneEureka(boolean preferSameZoneEureka) {
        this.preferSameZoneEureka = preferSameZoneEureka;
    }

    public void setLogDeltaDiff(boolean logDeltaDiff) {
        this.logDeltaDiff = logDeltaDiff;
    }

    public void setDisableDelta(boolean disableDelta) {
        this.disableDelta = disableDelta;
    }

    public void setFetchRemoteRegionsRegistry(String fetchRemoteRegionsRegistry) {
        this.fetchRemoteRegionsRegistry = fetchRemoteRegionsRegistry;
    }

    public void setAvailabilityZones(Map<String, String> availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    public void setFilterOnlyUpInstances(boolean filterOnlyUpInstances) {
        this.filterOnlyUpInstances = filterOnlyUpInstances;
    }

    public void setFetchRegistry(boolean fetchRegistry) {
        this.fetchRegistry = fetchRegistry;
    }

    public void setDollarReplacement(String dollarReplacement) {
        this.dollarReplacement = dollarReplacement;
    }

    public void setEscapeCharReplacement(String escapeCharReplacement) {
        this.escapeCharReplacement = escapeCharReplacement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EurekaClientConfigBean)) {
            return false;
        }
        EurekaClientConfigBean other = (EurekaClientConfigBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getRegistryFetchIntervalSeconds() != other.getRegistryFetchIntervalSeconds()) {
            return false;
        }
        if (this.getInstanceInfoReplicationIntervalSeconds() != other.getInstanceInfoReplicationIntervalSeconds()) {
            return false;
        }
        if (this.getInitialInstanceInfoReplicationIntervalSeconds() != other.getInitialInstanceInfoReplicationIntervalSeconds()) {
            return false;
        }
        if (this.getEurekaServiceUrlPollIntervalSeconds() != other.getEurekaServiceUrlPollIntervalSeconds()) {
            return false;
        }
        String this$proxyPort = this.getProxyPort();
        String other$proxyPort = other.getProxyPort();
        if (this$proxyPort == null ? other$proxyPort != null : !this$proxyPort.equals(other$proxyPort)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        String this$proxyUserName = this.getProxyUserName();
        String other$proxyUserName = other.getProxyUserName();
        if (this$proxyUserName == null ? other$proxyUserName != null : !this$proxyUserName.equals(other$proxyUserName)) {
            return false;
        }
        String this$proxyPassword = this.getProxyPassword();
        String other$proxyPassword = other.getProxyPassword();
        if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
            return false;
        }
        if (this.getEurekaServerReadTimeoutSeconds() != other.getEurekaServerReadTimeoutSeconds()) {
            return false;
        }
        if (this.getEurekaServerConnectTimeoutSeconds() != other.getEurekaServerConnectTimeoutSeconds()) {
            return false;
        }
        String this$backupRegistryImpl = this.getBackupRegistryImpl();
        String other$backupRegistryImpl = other.getBackupRegistryImpl();
        if (this$backupRegistryImpl == null ? other$backupRegistryImpl != null : !this$backupRegistryImpl.equals(other$backupRegistryImpl)) {
            return false;
        }
        if (this.getEurekaServerTotalConnections() != other.getEurekaServerTotalConnections()) {
            return false;
        }
        if (this.getEurekaServerTotalConnectionsPerHost() != other.getEurekaServerTotalConnectionsPerHost()) {
            return false;
        }
        String this$eurekaServerURLContext = this.getEurekaServerURLContext();
        String other$eurekaServerURLContext = other.getEurekaServerURLContext();
        if (this$eurekaServerURLContext == null ? other$eurekaServerURLContext != null : !this$eurekaServerURLContext.equals(other$eurekaServerURLContext)) {
            return false;
        }
        String this$eurekaServerPort = this.getEurekaServerPort();
        String other$eurekaServerPort = other.getEurekaServerPort();
        if (this$eurekaServerPort == null ? other$eurekaServerPort != null : !this$eurekaServerPort.equals(other$eurekaServerPort)) {
            return false;
        }
        String this$eurekaServerDNSName = this.getEurekaServerDNSName();
        String other$eurekaServerDNSName = other.getEurekaServerDNSName();
        if (this$eurekaServerDNSName == null ? other$eurekaServerDNSName != null : !this$eurekaServerDNSName.equals(other$eurekaServerDNSName)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        if (this.getEurekaConnectionIdleTimeoutSeconds() != other.getEurekaConnectionIdleTimeoutSeconds()) {
            return false;
        }
        String this$registryRefreshSingleVipAddress = this.getRegistryRefreshSingleVipAddress();
        String other$registryRefreshSingleVipAddress = other.getRegistryRefreshSingleVipAddress();
        if (this$registryRefreshSingleVipAddress == null ? other$registryRefreshSingleVipAddress != null : !this$registryRefreshSingleVipAddress.equals(other$registryRefreshSingleVipAddress)) {
            return false;
        }
        if (this.getHeartbeatExecutorThreadPoolSize() != other.getHeartbeatExecutorThreadPoolSize()) {
            return false;
        }
        if (this.getHeartbeatExecutorExponentialBackOffBound() != other.getHeartbeatExecutorExponentialBackOffBound()) {
            return false;
        }
        if (this.getCacheRefreshExecutorThreadPoolSize() != other.getCacheRefreshExecutorThreadPoolSize()) {
            return false;
        }
        if (this.getCacheRefreshExecutorExponentialBackOffBound() != other.getCacheRefreshExecutorExponentialBackOffBound()) {
            return false;
        }
        Map<String, String> this$serviceUrl = this.getServiceUrl();
        Map<String, String> other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !((Object)this$serviceUrl).equals(other$serviceUrl)) {
            return false;
        }
        if (this.isGZipContent() != other.isGZipContent()) {
            return false;
        }
        if (this.isUseDnsForFetchingServiceUrls() != other.isUseDnsForFetchingServiceUrls()) {
            return false;
        }
        if (this.isRegisterWithEureka() != other.isRegisterWithEureka()) {
            return false;
        }
        if (this.isPreferSameZoneEureka() != other.isPreferSameZoneEureka()) {
            return false;
        }
        if (this.isLogDeltaDiff() != other.isLogDeltaDiff()) {
            return false;
        }
        if (this.isDisableDelta() != other.isDisableDelta()) {
            return false;
        }
        String this$fetchRemoteRegionsRegistry = this.getFetchRemoteRegionsRegistry();
        String other$fetchRemoteRegionsRegistry = other.getFetchRemoteRegionsRegistry();
        if (this$fetchRemoteRegionsRegistry == null ? other$fetchRemoteRegionsRegistry != null : !this$fetchRemoteRegionsRegistry.equals(other$fetchRemoteRegionsRegistry)) {
            return false;
        }
        Map<String, String> this$availabilityZones = this.getAvailabilityZones();
        Map<String, String> other$availabilityZones = other.getAvailabilityZones();
        if (this$availabilityZones == null ? other$availabilityZones != null : !((Object)this$availabilityZones).equals(other$availabilityZones)) {
            return false;
        }
        if (this.isFilterOnlyUpInstances() != other.isFilterOnlyUpInstances()) {
            return false;
        }
        if (this.isFetchRegistry() != other.isFetchRegistry()) {
            return false;
        }
        String this$dollarReplacement = this.getDollarReplacement();
        String other$dollarReplacement = other.getDollarReplacement();
        if (this$dollarReplacement == null ? other$dollarReplacement != null : !this$dollarReplacement.equals(other$dollarReplacement)) {
            return false;
        }
        String this$escapeCharReplacement = this.getEscapeCharReplacement();
        String other$escapeCharReplacement = other.getEscapeCharReplacement();
        return !(this$escapeCharReplacement == null ? other$escapeCharReplacement != null : !this$escapeCharReplacement.equals(other$escapeCharReplacement));
    }

    public boolean canEqual(Object other) {
        return other instanceof EurekaClientConfigBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getRegistryFetchIntervalSeconds();
        result = result * 59 + this.getInstanceInfoReplicationIntervalSeconds();
        result = result * 59 + this.getInitialInstanceInfoReplicationIntervalSeconds();
        result = result * 59 + this.getEurekaServiceUrlPollIntervalSeconds();
        String $proxyPort = this.getProxyPort();
        result = result * 59 + ($proxyPort == null ? 0 : $proxyPort.hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 0 : $proxyHost.hashCode());
        String $proxyUserName = this.getProxyUserName();
        result = result * 59 + ($proxyUserName == null ? 0 : $proxyUserName.hashCode());
        String $proxyPassword = this.getProxyPassword();
        result = result * 59 + ($proxyPassword == null ? 0 : $proxyPassword.hashCode());
        result = result * 59 + this.getEurekaServerReadTimeoutSeconds();
        result = result * 59 + this.getEurekaServerConnectTimeoutSeconds();
        String $backupRegistryImpl = this.getBackupRegistryImpl();
        result = result * 59 + ($backupRegistryImpl == null ? 0 : $backupRegistryImpl.hashCode());
        result = result * 59 + this.getEurekaServerTotalConnections();
        result = result * 59 + this.getEurekaServerTotalConnectionsPerHost();
        String $eurekaServerURLContext = this.getEurekaServerURLContext();
        result = result * 59 + ($eurekaServerURLContext == null ? 0 : $eurekaServerURLContext.hashCode());
        String $eurekaServerPort = this.getEurekaServerPort();
        result = result * 59 + ($eurekaServerPort == null ? 0 : $eurekaServerPort.hashCode());
        String $eurekaServerDNSName = this.getEurekaServerDNSName();
        result = result * 59 + ($eurekaServerDNSName == null ? 0 : $eurekaServerDNSName.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 0 : $region.hashCode());
        result = result * 59 + this.getEurekaConnectionIdleTimeoutSeconds();
        String $registryRefreshSingleVipAddress = this.getRegistryRefreshSingleVipAddress();
        result = result * 59 + ($registryRefreshSingleVipAddress == null ? 0 : $registryRefreshSingleVipAddress.hashCode());
        result = result * 59 + this.getHeartbeatExecutorThreadPoolSize();
        result = result * 59 + this.getHeartbeatExecutorExponentialBackOffBound();
        result = result * 59 + this.getCacheRefreshExecutorThreadPoolSize();
        result = result * 59 + this.getCacheRefreshExecutorExponentialBackOffBound();
        Map<String, String> $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 0 : ((Object)$serviceUrl).hashCode());
        result = result * 59 + (this.isGZipContent() ? 79 : 97);
        result = result * 59 + (this.isUseDnsForFetchingServiceUrls() ? 79 : 97);
        result = result * 59 + (this.isRegisterWithEureka() ? 79 : 97);
        result = result * 59 + (this.isPreferSameZoneEureka() ? 79 : 97);
        result = result * 59 + (this.isLogDeltaDiff() ? 79 : 97);
        result = result * 59 + (this.isDisableDelta() ? 79 : 97);
        String $fetchRemoteRegionsRegistry = this.getFetchRemoteRegionsRegistry();
        result = result * 59 + ($fetchRemoteRegionsRegistry == null ? 0 : $fetchRemoteRegionsRegistry.hashCode());
        Map<String, String> $availabilityZones = this.getAvailabilityZones();
        result = result * 59 + ($availabilityZones == null ? 0 : ((Object)$availabilityZones).hashCode());
        result = result * 59 + (this.isFilterOnlyUpInstances() ? 79 : 97);
        result = result * 59 + (this.isFetchRegistry() ? 79 : 97);
        String $dollarReplacement = this.getDollarReplacement();
        result = result * 59 + ($dollarReplacement == null ? 0 : $dollarReplacement.hashCode());
        String $escapeCharReplacement = this.getEscapeCharReplacement();
        result = result * 59 + ($escapeCharReplacement == null ? 0 : $escapeCharReplacement.hashCode());
        return result;
    }

    public String toString() {
        return "EurekaClientConfigBean(enabled=" + this.isEnabled() + ", registryFetchIntervalSeconds=" + this.getRegistryFetchIntervalSeconds() + ", instanceInfoReplicationIntervalSeconds=" + this.getInstanceInfoReplicationIntervalSeconds() + ", initialInstanceInfoReplicationIntervalSeconds=" + this.getInitialInstanceInfoReplicationIntervalSeconds() + ", eurekaServiceUrlPollIntervalSeconds=" + this.getEurekaServiceUrlPollIntervalSeconds() + ", proxyPort=" + this.getProxyPort() + ", proxyHost=" + this.getProxyHost() + ", proxyUserName=" + this.getProxyUserName() + ", proxyPassword=" + this.getProxyPassword() + ", eurekaServerReadTimeoutSeconds=" + this.getEurekaServerReadTimeoutSeconds() + ", eurekaServerConnectTimeoutSeconds=" + this.getEurekaServerConnectTimeoutSeconds() + ", backupRegistryImpl=" + this.getBackupRegistryImpl() + ", eurekaServerTotalConnections=" + this.getEurekaServerTotalConnections() + ", eurekaServerTotalConnectionsPerHost=" + this.getEurekaServerTotalConnectionsPerHost() + ", eurekaServerURLContext=" + this.getEurekaServerURLContext() + ", eurekaServerPort=" + this.getEurekaServerPort() + ", eurekaServerDNSName=" + this.getEurekaServerDNSName() + ", region=" + this.getRegion() + ", eurekaConnectionIdleTimeoutSeconds=" + this.getEurekaConnectionIdleTimeoutSeconds() + ", registryRefreshSingleVipAddress=" + this.getRegistryRefreshSingleVipAddress() + ", heartbeatExecutorThreadPoolSize=" + this.getHeartbeatExecutorThreadPoolSize() + ", heartbeatExecutorExponentialBackOffBound=" + this.getHeartbeatExecutorExponentialBackOffBound() + ", cacheRefreshExecutorThreadPoolSize=" + this.getCacheRefreshExecutorThreadPoolSize() + ", cacheRefreshExecutorExponentialBackOffBound=" + this.getCacheRefreshExecutorExponentialBackOffBound() + ", serviceUrl=" + this.getServiceUrl() + ", gZipContent=" + this.isGZipContent() + ", useDnsForFetchingServiceUrls=" + this.isUseDnsForFetchingServiceUrls() + ", registerWithEureka=" + this.isRegisterWithEureka() + ", preferSameZoneEureka=" + this.isPreferSameZoneEureka() + ", logDeltaDiff=" + this.isLogDeltaDiff() + ", disableDelta=" + this.isDisableDelta() + ", fetchRemoteRegionsRegistry=" + this.getFetchRemoteRegionsRegistry() + ", availabilityZones=" + this.getAvailabilityZones() + ", filterOnlyUpInstances=" + this.isFilterOnlyUpInstances() + ", fetchRegistry=" + this.isFetchRegistry() + ", dollarReplacement=" + this.getDollarReplacement() + ", escapeCharReplacement=" + this.getEscapeCharReplacement() + ")";
    }
}

