/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import com.netflix.loadbalancer.ILoadBalancer;
import feign.Client;
import feign.Feign;
import feign.ribbon.LBClientFactory;
import feign.ribbon.RibbonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.feign.FeignAutoConfiguration;
import org.springframework.cloud.netflix.feign.ribbon.CachingLBClientFactory;
import org.springframework.cloud.netflix.feign.ribbon.SpringLBClientFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={ILoadBalancer.class, Feign.class})
@Configuration
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
public class FeignRibbonClientAutoConfiguration {
    @Autowired
    private SpringClientFactory factory;

    @Bean
    public SpringLBClientFactory springLBClientFactory() {
        return new SpringLBClientFactory(this.factory);
    }

    @Bean
    public CachingLBClientFactory cachingLBClientFactory() {
        return new CachingLBClientFactory(this.springLBClientFactory());
    }

    @Bean
    @ConditionalOnMissingBean
    public Client feignRibbonClient() {
        return RibbonClient.builder().lbClientFactory((LBClientFactory)this.cachingLBClientFactory()).build();
    }
}

