/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.servo;

import com.netflix.servo.publish.BaseMetricObserver;
import java.util.Date;
import java.util.List;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.cloud.netflix.servo.ServoMetricNaming;

final class ServoMetricObserver
extends BaseMetricObserver {
    private final MetricWriter metrics;
    private final ServoMetricNaming naming;

    public ServoMetricObserver(MetricWriter metrics, ServoMetricNaming naming) {
        super("spring-boot");
        this.metrics = metrics;
        this.naming = naming;
    }

    public void updateImpl(List<com.netflix.servo.Metric> servoMetrics) {
        for (com.netflix.servo.Metric servoMetric : servoMetrics) {
            String key = this.naming.getName(servoMetric);
            if (!servoMetric.hasNumberValue()) continue;
            this.metrics.set(new Metric(key, servoMetric.getNumberValue(), new Date(servoMetric.getTimestamp())));
        }
    }
}

