/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.archaius;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class ConfigurableEnvironmentConfiguration
extends AbstractConfiguration {
    private final ConfigurableEnvironment environment;

    public ConfigurableEnvironmentConfiguration(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    protected void addPropertyDirect(String key, Object value) {
    }

    public boolean isEmpty() {
        return !this.getKeys().hasNext();
    }

    public boolean containsKey(String key) {
        return this.environment.containsProperty(key);
    }

    public Object getProperty(String key) {
        return this.environment.getProperty(key);
    }

    public Iterator<String> getKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, PropertySource<?>> entry : this.getPropertySources().entrySet()) {
            PropertySource<?> source = entry.getValue();
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            String[] stringArray = enumerable.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                result.add(name);
                ++n2;
            }
        }
        return result.iterator();
    }

    private Map<String, PropertySource<?>> getPropertySources() {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = this.environment != null ? this.environment.getPropertySources() : new StandardEnvironment().getPropertySources();
        for (PropertySource source : sources) {
            this.extract("", map, source);
        }
        return map;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                this.extract(String.valueOf(source.getName()) + ":", map, nest);
            }
        } else {
            map.put(String.valueOf(root) + source.getName(), source);
        }
    }
}

