/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.support;

import feign.FeignException;
import feign.Response;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ResponseEntityDecoder
implements Decoder {
    private static final Logger log = LoggerFactory.getLogger(ResponseEntityDecoder.class);
    private Decoder decoder;

    public ResponseEntityDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(ResponseEntity.class)) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
            Object decodedObject = this.decoder.decode(response, type);
            Class<?> clazz = null;
            if (decodedObject != null) {
                clazz = decodedObject.getClass();
            }
            return this.createResponse(clazz, decodedObject, response);
        }
        return this.decoder.decode(response, type);
    }

    private <T> ResponseEntity<T> createResponse(Class<T> clazz, Object instance, Response response) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        for (String key : response.headers().keySet()) {
            headers.put((Object)key, new LinkedList((Collection)response.headers().get(key)));
        }
        Object retVal = null;
        if (clazz != null && instance != null) {
            retVal = clazz.cast(instance);
        }
        return new ResponseEntity(retVal, (MultiValueMap)headers, HttpStatus.valueOf((int)response.status()));
    }
}

