/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.support;

import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringMvcContract
extends Contract.BaseContract {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";

    public MethodMetadata parseAndValidatateMetadata(Method method) {
        MethodMetadata md = super.parseAndValidatateMetadata(method);
        RequestMapping classAnnotation = method.getDeclaringClass().getAnnotation(RequestMapping.class);
        if (classAnnotation != null) {
            if (classAnnotation.value().length > 0) {
                String pathValue = Util.emptyToNull((String)classAnnotation.value()[0]);
                Util.checkState((pathValue != null ? 1 : 0) != 0, (String)"RequestMapping.value() was empty on type %s", (Object[])new Object[]{method.getDeclaringClass().getName()});
                if (!pathValue.startsWith("/")) {
                    pathValue = "/" + pathValue;
                }
                md.template().insert(0, (CharSequence)pathValue);
            }
            if (!md.template().headers().containsKey(ACCEPT)) {
                this.parseProduces(md, method, classAnnotation);
            }
            if (!md.template().headers().containsKey(CONTENT_TYPE)) {
                this.parseConsumes(md, method, classAnnotation);
            }
            this.parseHeaders(md, method, classAnnotation);
        }
        return md;
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        String pathValue;
        if (!(methodAnnotation instanceof RequestMapping)) {
            return;
        }
        RequestMapping methodMapping = (RequestMapping)RequestMapping.class.cast(methodAnnotation);
        this.checkOne(method, methodMapping.method(), "method");
        data.template().method(methodMapping.method()[0].name());
        this.checkAtMostOne(method, methodMapping.value(), "value");
        if (methodMapping.value().length > 0 && (pathValue = Util.emptyToNull((String)methodMapping.value()[0])) != null) {
            if (!pathValue.startsWith("/") && !data.template().toString().endsWith("/")) {
                pathValue = "/" + pathValue;
            }
            data.template().append((CharSequence)pathValue);
        }
        this.parseProduces(data, method, methodMapping);
        this.parseConsumes(data, method, methodMapping);
        this.parseHeaders(data, method, methodMapping);
    }

    private void checkAtMostOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && (values.length == 0 || values.length == 1) ? 1 : 0) != 0, (String)"Method %s can only contain at most 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private void checkOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && values.length == 1 ? 1 : 0) != 0, (String)"Method %s can only contain 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        boolean isHttpAnnotation = false;
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Annotation parameterAnnotation = annotationArray[n2];
            Class<? extends Annotation> annotationType = parameterAnnotation.annotationType();
            if (annotationType == PathVariable.class) {
                name = ((PathVariable)PathVariable.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"PathVariable annotation was empty on param %s.", (Object[])new Object[]{paramIndex});
                this.nameParam(data, name, paramIndex);
                isHttpAnnotation = true;
                String varName = String.valueOf('{') + name + '}';
                if (data.template().url().indexOf(varName) == -1 && !this.searchMapValues(data.template().queries(), varName) && !this.searchMapValues(data.template().headers(), varName)) {
                    data.formParams().add(name);
                }
            } else if (annotationType == RequestParam.class) {
                name = ((RequestParam)RequestParam.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"QueryParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                Collection query = this.addTemplatedParam((Collection)data.template().queries().get(name), name);
                data.template().query(name, (Iterable)query);
                this.nameParam(data, name, paramIndex);
                isHttpAnnotation = true;
            } else if (annotationType == RequestHeader.class) {
                name = ((RequestHeader)RequestHeader.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"HeaderParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                Collection header = this.addTemplatedParam((Collection)data.template().headers().get(name), name);
                data.template().header(name, (Iterable)header);
                this.nameParam(data, name, paramIndex);
                isHttpAnnotation = true;
            }
            ++n2;
        }
        return isHttpAnnotation;
    }

    private <K, V> boolean searchMapValues(Map<K, Collection<V>> map, V search) {
        Collection<Collection<V>> values = map.values();
        if (values == null) {
            return false;
        }
        for (Collection<V> entry : values) {
            if (!entry.contains(search)) continue;
            return true;
        }
        return false;
    }

    private void parseProduces(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientAccepts;
        this.checkAtMostOne(method, annotation.produces(), "produces");
        String[] serverProduces = annotation.produces();
        String string = clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
        if (clientAccepts != null) {
            md.template().header(ACCEPT, new String[]{clientAccepts});
        }
    }

    private void parseConsumes(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientProduces;
        this.checkAtMostOne(method, annotation.consumes(), "consumes");
        String[] serverConsumes = annotation.consumes();
        String string = clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
        if (clientProduces != null) {
            md.template().header(CONTENT_TYPE, new String[]{clientProduces});
        }
    }

    private void parseHeaders(MethodMetadata md, Method method, RequestMapping annotation) {
        if (annotation.headers() != null && annotation.headers().length > 0) {
            String[] stringArray = annotation.headers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String header = stringArray[n2];
                int colon = header.indexOf(58);
                md.template().header(header.substring(0, colon), new String[]{header.substring(colon + 2)});
                ++n2;
            }
        }
    }
}

