/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import java.util.ArrayList;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class HystrixHealthIndicator
extends AbstractHealthIndicator {
    private static final Status CIRCUIT_OPEN = new Status("CIRCUIT_OPEN");

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        ArrayList<String> openCircuitBreakers = new ArrayList<String>();
        for (HystrixCommandMetrics metrics : HystrixCommandMetrics.getInstances()) {
            HystrixCircuitBreaker circuitBreaker = HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)metrics.getCommandKey());
            if (circuitBreaker == null || !circuitBreaker.isOpen()) continue;
            openCircuitBreakers.add(String.valueOf(metrics.getCommandGroup().name()) + "::" + metrics.getCommandKey().name());
        }
        if (openCircuitBreakers.size() > 0) {
            builder.status(CIRCUIT_OPEN).withDetail("openCircuitBreakers", openCircuitBreakers);
        } else {
            builder.up();
        }
    }
}

