/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.netflix.ribbon.RibbonClient;
import org.springframework.cloud.netflix.ribbon.RibbonClientSpecification;
import org.springframework.cloud.netflix.ribbon.RibbonClients;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class RibbonClientConfigurationRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map client;
        String name;
        Map attrs = metadata.getAnnotationAttributes(RibbonClients.class.getName(), true);
        if (attrs != null && attrs.containsKey("value")) {
            AnnotationAttributes[] clients;
            AnnotationAttributes[] annotationAttributesArray = clients = (AnnotationAttributes[])attrs.get("value");
            int n = clients.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationAttributes client2 = annotationAttributesArray[n2];
                this.registerClientConfiguration(registry, this.getClientName((Map<String, Object>)client2), client2.get((Object)"configuration"));
                ++n2;
            }
        }
        if (attrs != null && attrs.containsKey("defaultConfiguration")) {
            String name2 = metadata.hasEnclosingClass() ? "default." + metadata.getEnclosingClassName() : "default." + metadata.getClassName();
            this.registerClientConfiguration(registry, name2, attrs.get("defaultConfiguration"));
        }
        if ((name = this.getClientName(client = metadata.getAnnotationAttributes(RibbonClient.class.getName(), true))) != null) {
            this.registerClientConfiguration(registry, name, client.get("configuration"));
        }
    }

    private String getClientName(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String value = (String)client.get("value");
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("name");
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @RibbonClient");
    }

    private void registerClientConfiguration(BeanDefinitionRegistry registry, Object name, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RibbonClientSpecification.class);
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(name + ".RibbonClientSpecification", (BeanDefinition)builder.getBeanDefinition());
    }
}

