/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.servo;

import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import org.springframework.cloud.netflix.servo.ServoMetricNaming;

public class DefaultServoMetricNaming
implements ServoMetricNaming {
    private static final String JMX_DOMAIN_KEY = "JmxDomain";
    public static final String SERVO = "servo.";

    @Override
    public String getName(Metric metric) {
        MonitorConfig config = metric.getConfig();
        TagList tags = config.getTags();
        Tag domainTag = tags.getTag(JMX_DOMAIN_KEY);
        String name = domainTag != null ? this.handleJmxMetric(config, tags) : this.handleMetric(config, tags);
        return name.toLowerCase();
    }

    private String handleMetric(MonitorConfig config, TagList tags) {
        String type = this.cleanValue(tags.getTag(DataSourceType.KEY), false);
        String instanceName = this.cleanValue(tags.getTag("instance"), false);
        String name = this.cleanupIllegalCharacters(config.getName(), true);
        String statistic = this.cleanValue(tags.getTag("statistic"), false);
        StringBuilder nameBuilder = new StringBuilder();
        if (type != null) {
            nameBuilder.append(type).append(".");
        }
        nameBuilder.append(SERVO);
        if (instanceName != null) {
            nameBuilder.append(instanceName).append(".");
        }
        if (name != null) {
            nameBuilder.append(name).append(".");
        }
        if (statistic != null) {
            nameBuilder.append(statistic).append(".");
        }
        nameBuilder.deleteCharAt(nameBuilder.lastIndexOf("."));
        return nameBuilder.toString();
    }

    private String handleJmxMetric(MonitorConfig config, TagList tags) {
        String domain = this.cleanValue(tags.getTag(JMX_DOMAIN_KEY), true);
        String type = this.cleanValue(tags.getTag("Jmx.type"), false);
        String instanceName = this.cleanValue(tags.getTag("Jmx.instance"), false);
        String name = this.cleanValue(tags.getTag("Jmx.name"), true);
        String fieldName = this.cleanupIllegalCharacters(config.getName(), false);
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(domain).append(".");
        if (type != null) {
            nameBuilder.append(type).append(".");
        }
        nameBuilder.append(SERVO);
        if (instanceName != null) {
            nameBuilder.append(instanceName).append(".");
        }
        if (name != null) {
            nameBuilder.append(name).append(".");
        }
        if (fieldName != null) {
            nameBuilder.append(fieldName).append(".");
        }
        nameBuilder.deleteCharAt(nameBuilder.lastIndexOf("."));
        return nameBuilder.toString();
    }

    private String cleanValue(Tag tag, boolean allowPeriodsInName) {
        if (tag == null) {
            return null;
        }
        return this.cleanupIllegalCharacters(tag.getValue(), allowPeriodsInName);
    }

    private String cleanupIllegalCharacters(String s, boolean allowPeriodsInName) {
        if (!allowPeriodsInName) {
            s = s.replace(".", "_");
        }
        return s.replace(" ", "_");
    }
}

