/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.zuul.RoutesEndpoint;
import org.springframework.cloud.netflix.zuul.RoutesRefreshedEvent;
import org.springframework.cloud.netflix.zuul.ZuulConfiguration;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.ProxyRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.pre.PreDecorationFilter;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonRoutingFilter;
import org.springframework.cloud.netflix.zuul.filters.route.SimpleHostRoutingFilter;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ZuulProxyConfiguration
extends ZuulConfiguration {
    @Autowired(required=false)
    private TraceRepository traces;
    @Autowired
    private SpringClientFactory clientFactory;
    @Autowired
    private DiscoveryClient discovery;
    @Autowired
    private ZuulProperties zuulProperties;
    @Autowired
    private ServerProperties server;

    @Override
    @Bean
    public ProxyRouteLocator routeLocator() {
        return new ProxyRouteLocator(this.server.getServletPrefix(), this.discovery, this.zuulProperties);
    }

    @Bean
    public PreDecorationFilter preDecorationFilter() {
        return new PreDecorationFilter(this.routeLocator(), this.zuulProperties.isAddProxyHeaders());
    }

    @Bean
    public RibbonRoutingFilter ribbonRoutingFilter() {
        ProxyRequestHelper helper = new ProxyRequestHelper();
        if (this.traces != null) {
            helper.setTraces(this.traces);
        }
        RibbonRoutingFilter filter = new RibbonRoutingFilter(helper, this.clientFactory);
        return filter;
    }

    @Bean
    public SimpleHostRoutingFilter simpleHostRoutingFilter() {
        ProxyRequestHelper helper = new ProxyRequestHelper();
        if (this.traces != null) {
            helper.setTraces(this.traces);
        }
        return new SimpleHostRoutingFilter(helper);
    }

    @Override
    @Bean
    public ApplicationListener<ApplicationEvent> zuulRefreshRoutesListener() {
        return new ZuulRefreshListener();
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class RoutesEndpointConfiguration {
        @Autowired
        private ProxyRouteLocator routeLocator;

        protected RoutesEndpointConfiguration() {
        }

        @Bean
        public RoutesEndpoint zuulEndpoint() {
            return new RoutesEndpoint(this.routeLocator);
        }
    }

    private static class ZuulRefreshListener
    implements ApplicationListener<ApplicationEvent> {
        private HeartbeatMonitor monitor = new HeartbeatMonitor();
        @Autowired
        private ProxyRouteLocator routeLocator;
        @Autowired
        private ZuulHandlerMapping zuulHandlerMapping;

        private ZuulRefreshListener() {
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof InstanceRegisteredEvent || event instanceof RefreshScopeRefreshedEvent || event instanceof RoutesRefreshedEvent) {
                this.reset();
            } else if (event instanceof ParentHeartbeatEvent) {
                ParentHeartbeatEvent e = (ParentHeartbeatEvent)event;
                this.resetIfNeeded(e.getValue());
            } else if (event instanceof HeartbeatEvent) {
                HeartbeatEvent e = (HeartbeatEvent)event;
                this.resetIfNeeded(e.getValue());
            }
        }

        private void resetIfNeeded(Object value) {
            if (this.monitor.update(value)) {
                this.reset();
            }
        }

        private void reset() {
            this.routeLocator.resetRoutes();
            this.zuulHandlerMapping.registerHandlers();
        }
    }
}

