/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.util.HTTPRequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.http.HttpHeaders;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;

public class ProxyRequestHelper {
    private static final Log log = LogFactory.getLog(ProxyRequestHelper.class);
    public static final String IGNORED_HEADERS = "ignoredHeaders";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private TraceRepository traces;

    public void setTraces(TraceRepository traces) {
        this.traces = traces;
    }

    public String buildZuulRequestURI(HttpServletRequest request) {
        RequestContext context = RequestContext.getCurrentContext();
        String uri = request.getRequestURI();
        String contextURI = (String)context.get((Object)"requestURI");
        if (contextURI != null) {
            try {
                uri = UriUtils.encodePath((String)contextURI, (String)"ISO-8859-1");
            }
            catch (Exception e) {
                log.debug((Object)"unable to encode uri path from context, falling back to uri from request", (Throwable)e);
            }
        }
        return uri;
    }

    public MultiValueMap<String, String> buildZuulRequestQueryParams(HttpServletRequest request) {
        Map map = HTTPRequestUtils.getInstance().getQueryParams();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (map == null) {
            return params;
        }
        for (String key : map.keySet()) {
            for (String value : (List)map.get(key)) {
                params.add((Object)key, (Object)value);
            }
        }
        return params;
    }

    public MultiValueMap<String, String> buildZuulRequestHeaders(HttpServletRequest request) {
        RequestContext context = RequestContext.getCurrentContext();
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                if (!this.isIncludedHeader(name)) continue;
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    headers.add((Object)name, (Object)value);
                }
            }
        }
        Map zuulRequestHeaders = context.getZuulRequestHeaders();
        for (String header : zuulRequestHeaders.keySet()) {
            headers.set((Object)header, (Object)((String)zuulRequestHeaders.get(header)));
        }
        headers.set((Object)"Accept-Encoding", (Object)"gzip");
        return headers;
    }

    public void setResponse(int status, InputStream entity, MultiValueMap<String, String> headers) throws IOException {
        RequestContext context = RequestContext.getCurrentContext();
        RequestContext.getCurrentContext().setResponseStatusCode(status);
        if (entity != null) {
            RequestContext.getCurrentContext().setResponseDataStream(entity);
        }
        boolean isOriginResponseGzipped = false;
        if (headers.containsKey((Object)CONTENT_ENCODING)) {
            Collection collection = (Collection)headers.get((Object)CONTENT_ENCODING);
            for (String header : collection) {
                if (!HTTPRequestUtils.getInstance().isGzipped(header)) continue;
                isOriginResponseGzipped = true;
                break;
            }
        }
        context.setResponseGZipped(isOriginResponseGzipped);
        for (Map.Entry header : headers.entrySet()) {
            RequestContext ctx = RequestContext.getCurrentContext();
            String name = (String)header.getKey();
            for (String value : (List)header.getValue()) {
                ctx.addOriginResponseHeader(name, value);
                if (name.equalsIgnoreCase("content-length")) {
                    ctx.setOriginContentLength(value);
                }
                if (!this.isIncludedHeader(name)) continue;
                ctx.addZuulResponseHeader(name, value);
            }
        }
    }

    public void addIgnoredHeaders(String ... names) {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (!ctx.containsKey((Object)IGNORED_HEADERS)) {
            ctx.set(IGNORED_HEADERS, new HashSet());
        }
        Set set = (Set)ctx.get((Object)IGNORED_HEADERS);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            set.add(name.toLowerCase());
            ++n2;
        }
    }

    public boolean isIncludedHeader(String headerName) {
        Object object;
        String name = headerName.toLowerCase();
        RequestContext ctx = RequestContext.getCurrentContext();
        if (ctx.containsKey((Object)IGNORED_HEADERS) && (object = ctx.get((Object)IGNORED_HEADERS)) instanceof Collection && ((Collection)object).contains(name)) {
            return false;
        }
        switch (name) {
            case "content-length": 
            case "server": 
            case "connection": 
            case "host": 
            case "transfer-encoding": 
            case "content-encoding": {
                return false;
            }
        }
        return true;
    }

    public Map<String, Object> debug(String verb, String uri, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws IOException {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        if (this.traces != null) {
            RequestContext context = RequestContext.getCurrentContext();
            StringBuilder query = new StringBuilder();
            for (String param : params.keySet()) {
                for (String value : (List)params.get((Object)param)) {
                    query.append(param);
                    query.append("=");
                    query.append(value);
                    query.append("&");
                }
            }
            info.put("method", verb);
            info.put("path", uri);
            info.put("query", query.toString());
            info.put("remote", true);
            info.put("proxy", context.get((Object)"proxy"));
            LinkedHashMap trace = new LinkedHashMap();
            LinkedHashMap<String, Collection> input = new LinkedHashMap<String, Collection>();
            trace.put("request", input);
            info.put("headers", trace);
            for (Map.Entry entry : headers.entrySet()) {
                Collection collection = (Collection)entry.getValue();
                Object value = collection;
                if (collection.size() < 2) {
                    value = collection.isEmpty() ? "" : (String)collection.iterator().next();
                }
                input.put((String)entry.getKey(), (Collection)value);
            }
            RequestContext ctx = RequestContext.getCurrentContext();
            if (!ctx.isChunkedRequestBody() && requestEntity != null) {
                this.debugRequestEntity(info, (InputStream)ctx.getRequest().getInputStream());
            }
            this.traces.add(info);
            return info;
        }
        return info;
    }

    public void appendDebug(Map<String, Object> info, int status, MultiValueMap<String, String> headers) {
        if (this.traces != null) {
            Map trace = (Map)info.get("headers");
            LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
            trace.put("response", output);
            for (Map.Entry key : headers.entrySet()) {
                Collection collection = (Collection)key.getValue();
                Object value = collection;
                if (collection.size() < 2) {
                    value = collection.isEmpty() ? "" : (String)collection.iterator().next();
                }
                output.put((String)key.getKey(), value);
            }
            output.put("status", "" + status);
        }
    }

    private void debugRequestEntity(Map<String, Object> info, InputStream inputStream) throws IOException {
        if (RequestContext.getCurrentContext().isChunkedRequestBody()) {
            info.put("body", "<chunked>");
            return;
        }
        String entity = IOUtils.toString((InputStream)inputStream);
        if (StringUtils.hasText((String)entity)) {
            info.put("body", entity.length() <= 4096 ? entity : String.valueOf(entity.substring(0, 4096)) + "<truncated>");
        }
    }
}

