/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class ProxyRouteLocator
implements RouteLocator {
    private static final Log log = LogFactory.getLog(ProxyRouteLocator.class);
    public static final String DEFAULT_ROUTE = "/**";
    private DiscoveryClient discovery;
    private ZuulProperties properties;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private AtomicReference<Map<String, ZuulProperties.ZuulRoute>> routes = new AtomicReference();
    private Map<String, ZuulProperties.ZuulRoute> staticRoutes = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
    private String servletPath;

    public ProxyRouteLocator(String servletPath, DiscoveryClient discovery, ZuulProperties properties) {
        this.servletPath = StringUtils.hasText((String)servletPath) ? servletPath : (properties.getServletPath() != null ? properties.getServletPath() : "");
        this.discovery = discovery;
        this.properties = properties;
    }

    public void addRoute(String path, String location) {
        this.staticRoutes.put(path, new ZuulProperties.ZuulRoute(path, location));
        this.resetRoutes();
    }

    public void addRoute(ZuulProperties.ZuulRoute route) {
        this.staticRoutes.put(route.getPath(), route);
        this.resetRoutes();
    }

    @Override
    public Collection<String> getRoutePaths() {
        return this.getRoutes().keySet();
    }

    public Map<String, String> getRoutes() {
        if (this.routes.get() == null) {
            this.routes.set(this.locateRoutes());
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Iterator<String> iterator = this.routes.get().keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String url = key = iterator.next();
            values.put(url, this.routes.get().get(key).getLocation());
        }
        return values;
    }

    public ProxyRouteSpec getMatchingRoute(String path) {
        log.info((Object)("Finding route for path: " + path));
        String location = null;
        String targetPath = null;
        String id = null;
        String prefix = this.properties.getPrefix();
        log.debug((Object)("servletPath=" + this.servletPath));
        if (StringUtils.hasText((String)this.servletPath) && !this.servletPath.equals("/") && path.startsWith(this.servletPath)) {
            path = path.substring(this.servletPath.length());
        }
        log.debug((Object)("path=" + path));
        Boolean retryable = this.properties.getRetryable();
        for (Map.Entry<String, ZuulProperties.ZuulRoute> entry : this.routes.get().entrySet()) {
            int index;
            String pattern = entry.getKey();
            log.debug((Object)("Matching pattern:" + pattern));
            if (!this.pathMatcher.match(pattern, path)) continue;
            ZuulProperties.ZuulRoute route = entry.getValue();
            id = route.getId();
            location = route.getLocation();
            targetPath = path;
            if (path.startsWith(prefix) && this.properties.isStripPrefix()) {
                targetPath = path.substring(prefix.length());
            }
            if (route.isStripPrefix() && (index = route.getPath().indexOf("*") - 1) > 0) {
                String routePrefix = route.getPath().substring(0, index);
                targetPath = targetPath.replaceFirst(routePrefix, "");
                prefix = String.valueOf(prefix) + routePrefix;
            }
            if (route.getRetryable() == null) break;
            retryable = route.getRetryable();
            break;
        }
        return location == null ? null : new ProxyRouteSpec(id, targetPath, location, prefix, retryable);
    }

    public void resetRoutes() {
        this.routes.set(this.locateRoutes());
    }

    protected LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes() {
        LinkedHashMap<String, ZuulProperties.ZuulRoute> routesMap = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        this.addConfiguredRoutes(routesMap);
        routesMap.putAll(this.staticRoutes);
        if (this.discovery != null) {
            LinkedHashMap<String, ZuulProperties.ZuulRoute> staticServices = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
            for (ZuulProperties.ZuulRoute zuulRoute : routesMap.values()) {
                String serviceId = zuulRoute.getServiceId();
                if (serviceId == null) {
                    serviceId = zuulRoute.getId();
                }
                if (serviceId == null) continue;
                staticServices.put(serviceId, zuulRoute);
            }
            List list = this.discovery.getServices();
            String[] ignored = this.properties.getIgnoredServices().toArray(new String[0]);
            for (String serviceId : list) {
                ZuulProperties.ZuulRoute staticRoute;
                String key = "/" + serviceId + DEFAULT_ROUTE;
                if (staticServices.containsKey(serviceId) && ((ZuulProperties.ZuulRoute)staticServices.get(serviceId)).getUrl() == null && !StringUtils.hasText((String)(staticRoute = (ZuulProperties.ZuulRoute)staticServices.get(serviceId)).getLocation())) {
                    staticRoute.setLocation(serviceId);
                }
                if (PatternMatchUtils.simpleMatch((String[])ignored, (String)serviceId) || routesMap.containsKey(key)) continue;
                routesMap.put(key, new ZuulProperties.ZuulRoute(key, serviceId));
            }
        }
        if (routesMap.get(DEFAULT_ROUTE) != null) {
            ZuulProperties.ZuulRoute defaultRoute = routesMap.get(DEFAULT_ROUTE);
            routesMap.remove(DEFAULT_ROUTE);
            routesMap.put(DEFAULT_ROUTE, defaultRoute);
        }
        LinkedHashMap<String, ZuulProperties.ZuulRoute> values = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        for (Map.Entry entry : routesMap.entrySet()) {
            String path = (String)entry.getKey();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (StringUtils.hasText((String)this.properties.getPrefix()) && !(path = String.valueOf(this.properties.getPrefix()) + path).startsWith("/")) {
                path = "/" + path;
            }
            values.put(path, (ZuulProperties.ZuulRoute)entry.getValue());
        }
        return values;
    }

    protected void addConfiguredRoutes(Map<String, ZuulProperties.ZuulRoute> routes) {
        Map<String, ZuulProperties.ZuulRoute> routeEntries = this.properties.getRoutes();
        for (ZuulProperties.ZuulRoute entry : routeEntries.values()) {
            String route = entry.getPath();
            if (routes.containsKey(route)) {
                log.warn((Object)("Overwriting route " + route + ": already defined by " + routes.get(route)));
            }
            routes.put(route, entry);
        }
    }

    public String getTargetPath(String matchingRoute, String requestURI) {
        String path = this.getRoutes().get(matchingRoute);
        return path != null ? path : requestURI;
    }

    public static class ProxyRouteSpec {
        private String id;
        private String path;
        private String location;
        private String prefix;
        private Boolean retryable;

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Boolean getRetryable() {
            return this.retryable;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setRetryable(Boolean retryable) {
            this.retryable = retryable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyRouteSpec)) {
                return false;
            }
            ProxyRouteSpec other = (ProxyRouteSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$location = this.getLocation();
            String other$location = other.getLocation();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Boolean this$retryable = this.getRetryable();
            Boolean other$retryable = other.getRetryable();
            return !(this$retryable == null ? other$retryable != null : !((Object)this$retryable).equals(other$retryable));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProxyRouteSpec;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Boolean $retryable = this.getRetryable();
            result = result * 59 + ($retryable == null ? 43 : ((Object)$retryable).hashCode());
            return result;
        }

        public String toString() {
            return "ProxyRouteLocator.ProxyRouteSpec(id=" + this.getId() + ", path=" + this.getPath() + ", location=" + this.getLocation() + ", prefix=" + this.getPrefix() + ", retryable=" + this.getRetryable() + ")";
        }

        @ConstructorProperties(value={"id", "path", "location", "prefix", "retryable"})
        public ProxyRouteSpec(String id, String path, String location, String prefix, Boolean retryable) {
            this.id = id;
            this.path = path;
            this.location = location;
            this.prefix = prefix;
            this.retryable = retryable;
        }
    }
}

