/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.client.ClientRequest;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.niws.client.http.RestClient;
import com.netflix.zuul.context.RequestContext;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.springframework.util.MultiValueMap;

public class RibbonCommand
extends HystrixCommand<HttpResponse> {
    private RestClient restClient;
    private HttpRequest.Verb verb;
    private URI uri;
    private Boolean retryable;
    private MultiValueMap<String, String> headers;
    private MultiValueMap<String, String> params;
    private InputStream requestEntity;

    public RibbonCommand(RestClient restClient, HttpRequest.Verb verb, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws URISyntaxException {
        this("default", restClient, verb, uri, retryable, headers, params, requestEntity);
    }

    public RibbonCommand(String commandKey, RestClient restClient, HttpRequest.Verb verb, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws URISyntaxException {
        super(RibbonCommand.getSetter(commandKey));
        this.restClient = restClient;
        this.verb = verb;
        this.uri = new URI(uri);
        this.retryable = retryable;
        this.headers = headers;
        this.params = params;
        this.requestEntity = requestEntity;
    }

    private static HystrixCommand.Setter getSetter(String commandKey) {
        String name = "zuul.eureka." + commandKey + ".semaphore.maxSemaphores";
        DynamicIntProperty value = DynamicPropertyFactory.getInstance().getIntProperty(name, 100);
        HystrixCommandProperties.Setter setter = HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(value.get());
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"RibbonCommand")).andCommandKey(HystrixCommandKey.Factory.asKey((String)(String.valueOf(commandKey) + "RibbonCommand"))).andCommandPropertiesDefaults(setter);
    }

    protected HttpResponse run() throws Exception {
        return this.forward();
    }

    private HttpResponse forward() throws Exception {
        List values;
        RequestContext context = RequestContext.getCurrentContext();
        HttpRequest.Builder builder = HttpRequest.newBuilder().verb(this.verb).uri(this.uri).entity((Object)this.requestEntity);
        if (this.retryable != null) {
            builder.setRetriable(this.retryable.booleanValue());
        }
        for (String name : this.headers.keySet()) {
            values = (List)this.headers.get((Object)name);
            for (String value : values) {
                builder.header(name, value);
            }
        }
        for (String name : this.params.keySet()) {
            values = (List)this.params.get((Object)name);
            for (String value : values) {
                builder.queryParams(name, value);
            }
        }
        HttpRequest httpClientRequest = builder.build();
        HttpResponse response = (HttpResponse)this.restClient.executeWithLoadBalancer((ClientRequest)httpClientRequest);
        context.set("ribbonResponse", (Object)response);
        if (this.isResponseTimedOut() && response != null) {
            response.close();
        }
        return response;
    }
}

