/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class SimpleHostRoutingFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(SimpleHostRoutingFilter.class);
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private static final Runnable CLIENTLOADER = new Runnable(){

        @Override
        public void run() {
            SimpleHostRoutingFilter.loadClient();
        }
    };
    private static final DynamicIntProperty SOCKET_TIMEOUT = DynamicPropertyFactory.getInstance().getIntProperty("zuul.host.socket-timeout-millis", 10000);
    private static final DynamicIntProperty CONNECTION_TIMEOUT = DynamicPropertyFactory.getInstance().getIntProperty("zuul.host.connect-timeout-millis", 2000);
    private static final AtomicReference<HttpClient> CLIENT = new AtomicReference<HttpClient>(SimpleHostRoutingFilter.newClient());
    private static final Timer CONNECTION_MANAGER_TIMER = new Timer("SimpleHostRoutingFilter.CONNECTION_MANAGER_TIMER", true);
    private ProxyRequestHelper helper;

    static {
        SOCKET_TIMEOUT.addCallback(CLIENTLOADER);
        CONNECTION_TIMEOUT.addCallback(CLIENTLOADER);
        CONNECTION_MANAGER_TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    HttpClient hc = (HttpClient)CLIENT.get();
                    if (hc == null) {
                        return;
                    }
                    hc.getConnectionManager().closeExpiredConnections();
                }
                catch (Throwable ex) {
                    log.error((Object)"error closing expired connections", ex);
                }
            }
        }, 30000L, 5000L);
    }

    public SimpleHostRoutingFilter() {
        this(new ProxyRequestHelper());
    }

    public SimpleHostRoutingFilter(ProxyRequestHelper helper) {
        this.helper = helper;
    }

    @PreDestroy
    public void stop() {
        CONNECTION_MANAGER_TIMER.cancel();
    }

    public String filterType() {
        return "route";
    }

    public int filterOrder() {
        return 100;
    }

    public boolean shouldFilter() {
        return RequestContext.getCurrentContext().getRouteHost() != null && RequestContext.getCurrentContext().sendZuulResponse();
    }

    public Object run() {
        RequestContext context = RequestContext.getCurrentContext();
        HttpServletRequest request = context.getRequest();
        MultiValueMap<String, String> headers = this.helper.buildZuulRequestHeaders(request);
        MultiValueMap<String, String> params = this.helper.buildZuulRequestQueryParams(request);
        String verb = this.getVerb(request);
        InputStream requestEntity = this.getRequestBody(request);
        HttpClient httpclient = CLIENT.get();
        String uri = this.helper.buildZuulRequestURI(request);
        try {
            HttpResponse response = this.forward(httpclient, verb, uri, request, headers, params, requestEntity);
            this.setResponse(response);
        }
        catch (Exception ex) {
            context.set("error.status_code", (Object)500);
            context.set("error.exception", (Object)ex);
        }
        return null;
    }

    private HttpResponse forward(HttpClient httpclient, String verb, String uri, HttpServletRequest request, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws Exception {
        BasicHttpRequest httpRequest;
        Map<String, Object> info = this.helper.debug(verb, uri, headers, params, requestEntity);
        URL host = RequestContext.getCurrentContext().getRouteHost();
        HttpHost httpHost = this.getHttpHost(host);
        uri = StringUtils.cleanPath((String)(String.valueOf(host.getPath()) + uri));
        switch (verb.toUpperCase()) {
            case "POST": {
                HttpPost httpPost = new HttpPost(String.valueOf(uri) + this.getQueryString());
                httpRequest = httpPost;
                httpPost.setEntity((HttpEntity)new InputStreamEntity(requestEntity, (long)request.getContentLength()));
                break;
            }
            case "PUT": {
                HttpPut httpPut = new HttpPut(String.valueOf(uri) + this.getQueryString());
                httpRequest = httpPut;
                httpPut.setEntity((HttpEntity)new InputStreamEntity(requestEntity, (long)request.getContentLength()));
                break;
            }
            case "PATCH": {
                HttpPatch httpPatch = new HttpPatch(String.valueOf(uri) + this.getQueryString());
                httpRequest = httpPatch;
                httpPatch.setEntity((HttpEntity)new InputStreamEntity(requestEntity, (long)request.getContentLength()));
                break;
            }
            default: {
                httpRequest = new BasicHttpRequest(verb, String.valueOf(uri) + this.getQueryString());
                log.debug((Object)(String.valueOf(uri) + this.getQueryString()));
            }
        }
        httpRequest.setHeaders(this.convertHeaders(headers));
        log.debug((Object)(String.valueOf(httpHost.getHostName()) + " " + httpHost.getPort() + " " + httpHost.getSchemeName()));
        HttpResponse zuulResponse = this.forwardRequest(httpclient, httpHost, (HttpRequest)httpRequest);
        this.helper.appendDebug(info, zuulResponse.getStatusLine().getStatusCode(), this.revertHeaders(zuulResponse.getAllHeaders()));
        return zuulResponse;
    }

    private MultiValueMap<String, String> revertHeaders(Header[] headers) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String name = header.getName();
            if (!map.containsKey((Object)name)) {
                map.put((Object)name, new ArrayList());
            }
            ((List)map.get((Object)name)).add(header.getValue());
            ++n2;
        }
        return map;
    }

    private Header[] convertHeaders(MultiValueMap<String, String> headers) {
        ArrayList<BasicHeader> list = new ArrayList<BasicHeader>();
        for (String name : headers.keySet()) {
            for (String value : (List)headers.get((Object)name)) {
                list.add(new BasicHeader(name, value));
            }
        }
        return (Header[])list.toArray(new BasicHeader[0]);
    }

    private HttpResponse forwardRequest(HttpClient httpclient, HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        return httpclient.execute(httpHost, httpRequest);
    }

    private String getQueryString() {
        HttpServletRequest request = RequestContext.getCurrentContext().getRequest();
        String query = request.getQueryString();
        return query != null ? "?" + query : "";
    }

    private HttpHost getHttpHost(URL host) {
        HttpHost httpHost = new HttpHost(host.getHost(), host.getPort(), host.getProtocol());
        return httpHost;
    }

    private InputStream getRequestBody(HttpServletRequest request) {
        ServletInputStream requestEntity = null;
        try {
            requestEntity = request.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return requestEntity;
    }

    private String getVerb(HttpServletRequest request) {
        String sMethod = request.getMethod();
        return sMethod.toUpperCase();
    }

    private void setResponse(HttpResponse response) throws IOException {
        this.helper.setResponse(response.getStatusLine().getStatusCode(), response.getEntity() == null ? null : response.getEntity().getContent(), this.revertHeaders(response.getAllHeaders()));
    }

    private static ClientConnectionManager newConnectionManager() throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        MySSLSocketFactory sf = new MySSLSocketFactory(trustStore);
        sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)sf, 443));
        registry.register(new Scheme("https", (SocketFactory)sf, 8443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(registry);
        cm.setMaxTotal(Integer.parseInt(System.getProperty("zuul.max.host.connections", "200")));
        cm.setDefaultMaxPerRoute(Integer.parseInt(System.getProperty("zuul.max.host.connections", "20")));
        return cm;
    }

    private static void loadClient() {
        final HttpClient oldClient = CLIENT.get();
        CLIENT.set(SimpleHostRoutingFilter.newClient());
        if (oldClient != null) {
            CONNECTION_MANAGER_TIMER.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        oldClient.getConnectionManager().shutdown();
                    }
                    catch (Throwable ex) {
                        log.error((Object)"error shutting down old connection manager", ex);
                    }
                }
            }, 30000L);
        }
    }

    private static HttpClient newClient() {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient(SimpleHostRoutingFilter.newConnectionManager());
            HttpParams httpParams = httpclient.getParams();
            httpParams.setIntParameter("http.socket.timeout", SOCKET_TIMEOUT.get());
            httpParams.setIntParameter("http.connection.timeout", CONNECTION_TIMEOUT.get());
            httpclient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
            httpParams.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
            httpclient.setRedirectStrategy(new RedirectStrategy(){

                public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) {
                    return false;
                }

                public HttpUriRequest getRedirect(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) {
                    return null;
                }
            });
            return httpclient;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class MySSLSocketFactory
    extends SSLSocketFactory {
        private SSLContext sslContext = SSLContext.getInstance("TLS");

        public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            TrustManager[] tms = new TrustManager[]{tm};
            this.sslContext.init(null, tms, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

