/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics;

import com.netflix.servo.monitor.Monitors;
import org.aspectj.lang.JoinPoint;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.netflix.metrics.MetricsClientHttpRequestInterceptor;
import org.springframework.cloud.netflix.metrics.MetricsHandlerInterceptor;
import org.springframework.cloud.netflix.metrics.RestTemplateUrlTemplateCapturingAspect;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.netflix.metrics.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={Monitors.class, MetricReader.class})
public class MetricsInterceptorConfiguration {

    @Configuration
    @ConditionalOnBean(value={RestTemplate.class})
    static class MetricsRestTemplateConfiguration {
        MetricsRestTemplateConfiguration() {
        }

        @Bean
        MetricsClientHttpRequestInterceptor spectatorLoggingClientHttpRequestInterceptor() {
            return new MetricsClientHttpRequestInterceptor();
        }

        @Bean
        BeanPostProcessor spectatorRestTemplateInterceptorPostProcessor() {
            return new MetricsInterceptorPostProcessor();
        }

        private static class MetricsInterceptorPostProcessor
        implements BeanPostProcessor,
        ApplicationContextAware {
            private ApplicationContext context;
            private MetricsClientHttpRequestInterceptor interceptor;

            private MetricsInterceptorPostProcessor() {
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) {
                if (bean instanceof RestTemplate) {
                    if (this.interceptor == null) {
                        this.interceptor = (MetricsClientHttpRequestInterceptor)this.context.getBean(MetricsClientHttpRequestInterceptor.class);
                    }
                    ((RestTemplate)bean).getInterceptors().add(this.interceptor);
                }
                return bean;
            }

            public void setApplicationContext(ApplicationContext context) throws BeansException {
                this.context = context;
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={JoinPoint.class})
    @ConditionalOnProperty(value={"spring.aop.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnBean(value={RestTemplate.class})
    static class MetricsRestTemplateAspectConfiguration {
        MetricsRestTemplateAspectConfiguration() {
        }

        @Bean
        RestTemplateUrlTemplateCapturingAspect restTemplateUrlTemplateCapturingAspect() {
            return new RestTemplateUrlTemplateCapturingAspect();
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    static class MetricsWebResourceConfiguration
    extends WebMvcConfigurerAdapter {
        MetricsWebResourceConfiguration() {
        }

        @Bean
        MetricsHandlerInterceptor servoMonitoringWebResourceInterceptor() {
            return new MetricsHandlerInterceptor();
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.servoMonitoringWebResourceInterceptor());
        }
    }
}

