/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpRequest;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpResponse;
import org.springframework.web.util.UriComponentsBuilder;

public class RibbonLoadBalancingHttpClient
extends AbstractLoadBalancerAwareClient<RibbonApacheHttpRequest, RibbonApacheHttpResponse> {
    private final HttpClient delegate = HttpClientBuilder.create().build();
    private int connectTimeout;
    private int readTimeout;
    private boolean secure;
    private boolean followRedirects;
    private boolean okToRetryOnAllOperations;

    public RibbonLoadBalancingHttpClient() {
        super(null);
        this.setRetryHandler(RetryHandler.DEFAULT);
    }

    public RibbonLoadBalancingHttpClient(ILoadBalancer lb) {
        super(lb);
        this.setRetryHandler(RetryHandler.DEFAULT);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
        this.connectTimeout = clientConfig.getPropertyAsInteger(CommonClientConfigKey.ConnectTimeout, 2000);
        this.readTimeout = clientConfig.getPropertyAsInteger(CommonClientConfigKey.ReadTimeout, 5000);
        this.secure = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.IsSecure, false);
        this.followRedirects = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.FollowRedirects, DefaultClientConfigImpl.DEFAULT_FOLLOW_REDIRECTS.booleanValue());
        this.okToRetryOnAllOperations = clientConfig.getPropertyAsBoolean(CommonClientConfigKey.OkToRetryOnAllOperations, DefaultClientConfigImpl.DEFAULT_OK_TO_RETRY_ON_ALL_OPERATIONS.booleanValue());
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonApacheHttpRequest request, IClientConfig requestConfig) {
        if (this.okToRetryOnAllOperations) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        if (!request.getMethod().equals("GET")) {
            return new RequestSpecificRetryHandler(true, false, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
    }

    public RibbonApacheHttpResponse execute(RibbonApacheHttpRequest request, IClientConfig configOverride) throws Exception {
        RequestConfig.Builder builder = RequestConfig.custom();
        if (configOverride != null) {
            builder.setConnectTimeout(((Integer)configOverride.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue());
            builder.setConnectionRequestTimeout(((Integer)configOverride.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue());
            builder.setRedirectsEnabled(((Boolean)configOverride.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue());
        } else {
            builder.setConnectTimeout(this.connectTimeout);
            builder.setConnectionRequestTimeout(this.readTimeout);
            builder.setRedirectsEnabled(this.followRedirects);
        }
        RequestConfig requestConfig = builder.build();
        if (this.isSecure(configOverride)) {
            URI secureUri = UriComponentsBuilder.fromUri((URI)request.getUri()).scheme("https").build().toUri();
            request = request.withNewUri(secureUri);
        }
        HttpUriRequest httpUriRequest = request.toRequest(requestConfig);
        HttpResponse httpResponse = this.delegate.execute(httpUriRequest);
        return new RibbonApacheHttpResponse(httpResponse, httpUriRequest.getURI());
    }

    private boolean isSecure(IClientConfig config) {
        return config != null ? (Boolean)config.get(CommonClientConfigKey.IsSecure) : this.secure;
    }
}

