/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.util.RequestUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class SimpleRouteLocator
implements RouteLocator {
    private static final Log log = LogFactory.getLog(SimpleRouteLocator.class);
    private ZuulProperties properties;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private String dispatcherServletPath = "/";
    private String zuulServletPath;
    private AtomicReference<Map<String, ZuulProperties.ZuulRoute>> routes = new AtomicReference();

    public SimpleRouteLocator(String servletPath, ZuulProperties properties) {
        this.properties = properties;
        if (servletPath != null && StringUtils.hasText((String)servletPath)) {
            this.dispatcherServletPath = servletPath;
        }
        this.zuulServletPath = properties.getServletPath();
    }

    @Override
    public List<Route> getRoutes() {
        if (this.routes.get() == null) {
            this.routes.set(this.locateRoutes());
        }
        ArrayList<Route> values = new ArrayList<Route>();
        for (String url : this.routes.get().keySet()) {
            ZuulProperties.ZuulRoute route = this.routes.get().get(url);
            String path = route.getPath();
            values.add(this.getRoute(route, path));
        }
        return values;
    }

    @Override
    public Collection<String> getIgnoredPaths() {
        return this.properties.getIgnoredPatterns();
    }

    @Override
    public Route getMatchingRoute(String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finding route for path: " + path));
        }
        if (this.routes.get() == null) {
            this.routes.set(this.locateRoutes());
        }
        log.debug((Object)("servletPath=" + this.dispatcherServletPath));
        log.debug((Object)("zuulServletPath=" + this.zuulServletPath));
        log.debug((Object)("RequestUtils.isDispatcherServletRequest()=" + RequestUtils.isDispatcherServletRequest()));
        log.debug((Object)("RequestUtils.isZuulServletRequest()=" + RequestUtils.isZuulServletRequest()));
        String adjustedPath = this.adjustPath(path);
        ZuulProperties.ZuulRoute route = null;
        if (!this.matchesIgnoredPatterns(adjustedPath)) {
            for (Map.Entry<String, ZuulProperties.ZuulRoute> entry : this.routes.get().entrySet()) {
                String pattern = entry.getKey();
                log.debug((Object)("Matching pattern:" + pattern));
                if (!this.pathMatcher.match(pattern, adjustedPath)) continue;
                route = entry.getValue();
                break;
            }
        }
        log.debug((Object)("route matched=" + route));
        return this.getRoute(route, adjustedPath);
    }

    private Route getRoute(ZuulProperties.ZuulRoute route, String path) {
        int index;
        if (route == null) {
            return null;
        }
        String targetPath = path;
        String prefix = this.properties.getPrefix();
        if (path.startsWith(prefix) && this.properties.isStripPrefix()) {
            targetPath = path.substring(prefix.length());
        }
        if (route.isStripPrefix() && (index = route.getPath().indexOf("*") - 1) > 0) {
            String routePrefix = route.getPath().substring(0, index);
            targetPath = targetPath.replaceFirst(routePrefix, "");
            prefix = prefix + routePrefix;
        }
        Boolean retryable = this.properties.getRetryable();
        if (route.getRetryable() != null) {
            retryable = route.getRetryable();
        }
        return new Route(route.getId(), targetPath, route.getLocation(), prefix, retryable, route.isCustomSensitiveHeaders() ? route.getSensitiveHeaders() : null);
    }

    protected void doRefresh() {
        this.routes.set(this.locateRoutes());
    }

    protected Map<String, ZuulProperties.ZuulRoute> locateRoutes() {
        LinkedHashMap<String, ZuulProperties.ZuulRoute> routesMap = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        for (ZuulProperties.ZuulRoute route : this.properties.getRoutes().values()) {
            routesMap.put(route.getPath(), route);
        }
        return routesMap;
    }

    protected boolean matchesIgnoredPatterns(String path) {
        for (String pattern : this.properties.getIgnoredPatterns()) {
            log.debug((Object)("Matching ignored pattern:" + pattern));
            if (!this.pathMatcher.match(pattern, path)) continue;
            log.debug((Object)("Path " + path + " matches ignored pattern " + pattern));
            return true;
        }
        return false;
    }

    private String adjustPath(String path) {
        String adjustedPath = path;
        if (RequestUtils.isDispatcherServletRequest() && StringUtils.hasText((String)this.dispatcherServletPath)) {
            if (!this.dispatcherServletPath.equals("/")) {
                adjustedPath = path.substring(this.dispatcherServletPath.length());
                log.debug((Object)"Stripped dispatcherServletPath");
            }
        } else if (RequestUtils.isZuulServletRequest() && StringUtils.hasText((String)this.zuulServletPath) && !this.zuulServletPath.equals("/")) {
            adjustedPath = path.substring(this.zuulServletPath.length());
            log.debug((Object)"Stripped zuulServletPath");
        }
        log.debug((Object)("adjustedPath=" + path));
        return adjustedPath;
    }
}

