/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class SimpleHostRoutingFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(SimpleHostRoutingFilter.class);
    private static final DynamicIntProperty SOCKET_TIMEOUT = DynamicPropertyFactory.getInstance().getIntProperty("zuul.host.socket-timeout-millis", 10000);
    private static final DynamicIntProperty CONNECTION_TIMEOUT = DynamicPropertyFactory.getInstance().getIntProperty("zuul.host.connect-timeout-millis", 2000);
    private static final String ERROR_STATUS_CODE = "error.status_code";
    private final Timer connectionManagerTimer = new Timer("SimpleHostRoutingFilter.connectionManagerTimer", true);
    private boolean sslHostnameValidationEnabled;
    private ProxyRequestHelper helper;
    private ZuulProperties.Host hostProperties;
    private PoolingHttpClientConnectionManager connectionManager;
    private CloseableHttpClient httpClient;
    private final Runnable clientloader = new Runnable(){

        @Override
        public void run() {
            try {
                SimpleHostRoutingFilter.this.httpClient.close();
            }
            catch (IOException ex) {
                log.error((Object)"error closing client", (Throwable)ex);
            }
            SimpleHostRoutingFilter.this.httpClient = SimpleHostRoutingFilter.this.newClient();
        }
    };

    public SimpleHostRoutingFilter(ProxyRequestHelper helper, ZuulProperties properties) {
        this.helper = helper;
        this.hostProperties = properties.getHost();
        this.sslHostnameValidationEnabled = properties.isSslHostnameValidationEnabled();
    }

    @PostConstruct
    private void initialize() {
        this.httpClient = this.newClient();
        SOCKET_TIMEOUT.addCallback(this.clientloader);
        CONNECTION_TIMEOUT.addCallback(this.clientloader);
        this.connectionManagerTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (SimpleHostRoutingFilter.this.connectionManager == null) {
                    return;
                }
                SimpleHostRoutingFilter.this.connectionManager.closeExpiredConnections();
            }
        }, 30000L, 5000L);
    }

    @PreDestroy
    public void stop() {
        this.connectionManagerTimer.cancel();
    }

    public String filterType() {
        return "route";
    }

    public int filterOrder() {
        return 100;
    }

    public boolean shouldFilter() {
        return RequestContext.getCurrentContext().getRouteHost() != null && RequestContext.getCurrentContext().sendZuulResponse();
    }

    public Object run() {
        RequestContext context = RequestContext.getCurrentContext();
        HttpServletRequest request = context.getRequest();
        MultiValueMap<String, String> headers = this.helper.buildZuulRequestHeaders(request);
        MultiValueMap<String, String> params = this.helper.buildZuulRequestQueryParams(request);
        String verb = this.getVerb(request);
        InputStream requestEntity = this.getRequestBody(request);
        if (request.getContentLength() < 0) {
            context.setChunkedRequestBody();
        }
        String uri = this.helper.buildZuulRequestURI(request);
        this.helper.addIgnoredHeaders(new String[0]);
        try {
            HttpResponse response = this.forward((HttpClient)this.httpClient, verb, uri, request, headers, params, requestEntity);
            this.setResponse(response);
        }
        catch (Exception ex) {
            context.set(ERROR_STATUS_CODE, (Object)500);
            context.set("error.exception", (Object)ex);
        }
        return null;
    }

    protected PoolingHttpClientConnectionManager newConnectionManager() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
            RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE);
            if (this.sslHostnameValidationEnabled) {
                registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslContext));
            } else {
                registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
            }
            Registry registry = registryBuilder.build();
            this.connectionManager = new PoolingHttpClientConnectionManager(registry);
            this.connectionManager.setMaxTotal(this.hostProperties.getMaxTotalConnections());
            this.connectionManager.setDefaultMaxPerRoute(this.hostProperties.getMaxPerRouteConnections());
            return this.connectionManager;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected CloseableHttpClient newClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(SOCKET_TIMEOUT.get()).setConnectTimeout(CONNECTION_TIMEOUT.get()).setCookieSpec("ignoreCookies").build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (!this.sslHostnameValidationEnabled) {
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.newConnectionManager()).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).setRedirectStrategy(new RedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return null;
            }
        }).build();
    }

    private HttpResponse forward(HttpClient httpclient, String verb, String uri, HttpServletRequest request, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws Exception {
        BasicHttpRequest httpRequest;
        Map<String, Object> info = this.helper.debug(verb, uri, headers, params, requestEntity);
        URL host = RequestContext.getCurrentContext().getRouteHost();
        HttpHost httpHost = this.getHttpHost(host);
        uri = StringUtils.cleanPath((String)(host.getPath() + uri).replaceAll("/{2,}", "/"));
        int contentLength = request.getContentLength();
        InputStreamEntity entity = new InputStreamEntity(requestEntity, (long)contentLength, request.getContentType() != null ? ContentType.create((String)request.getContentType()) : null);
        switch (verb.toUpperCase()) {
            case "POST": {
                HttpPost httpPost = new HttpPost(uri + this.helper.getQueryString(params));
                httpRequest = httpPost;
                httpPost.setEntity((HttpEntity)entity);
                break;
            }
            case "PUT": {
                HttpPut httpPut = new HttpPut(uri + this.helper.getQueryString(params));
                httpRequest = httpPut;
                httpPut.setEntity((HttpEntity)entity);
                break;
            }
            case "PATCH": {
                HttpPatch httpPatch = new HttpPatch(uri + this.helper.getQueryString(params));
                httpRequest = httpPatch;
                httpPatch.setEntity((HttpEntity)entity);
                break;
            }
            default: {
                httpRequest = new BasicHttpRequest(verb, uri + this.helper.getQueryString(params));
                log.debug((Object)(uri + this.helper.getQueryString(params)));
            }
        }
        httpRequest.setHeaders(this.convertHeaders(headers));
        log.debug((Object)(httpHost.getHostName() + " " + httpHost.getPort() + " " + httpHost.getSchemeName()));
        HttpResponse zuulResponse = this.forwardRequest(httpclient, httpHost, (HttpRequest)httpRequest);
        this.helper.appendDebug(info, zuulResponse.getStatusLine().getStatusCode(), this.revertHeaders(zuulResponse.getAllHeaders()));
        return zuulResponse;
    }

    private MultiValueMap<String, String> revertHeaders(Header[] headers) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (Header header : headers) {
            String name = header.getName();
            if (!map.containsKey((Object)name)) {
                map.put((Object)name, new ArrayList());
            }
            ((List)map.get((Object)name)).add(header.getValue());
        }
        return map;
    }

    private Header[] convertHeaders(MultiValueMap<String, String> headers) {
        ArrayList<BasicHeader> list = new ArrayList<BasicHeader>();
        for (String name : headers.keySet()) {
            for (String value : (List)headers.get((Object)name)) {
                list.add(new BasicHeader(name, value));
            }
        }
        return (Header[])list.toArray(new BasicHeader[0]);
    }

    private HttpResponse forwardRequest(HttpClient httpclient, HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        return httpclient.execute(httpHost, httpRequest);
    }

    private HttpHost getHttpHost(URL host) {
        HttpHost httpHost = new HttpHost(host.getHost(), host.getPort(), host.getProtocol());
        return httpHost;
    }

    private InputStream getRequestBody(HttpServletRequest request) {
        ServletInputStream requestEntity = null;
        try {
            requestEntity = request.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return requestEntity;
    }

    private String getVerb(HttpServletRequest request) {
        String sMethod = request.getMethod();
        return sMethod.toUpperCase();
    }

    private void setResponse(HttpResponse response) throws IOException {
        this.helper.setResponse(response.getStatusLine().getStatusCode(), response.getEntity() == null ? null : response.getEntity().getContent(), this.revertHeaders(response.getAllHeaders()));
    }

    protected void addIgnoredHeaders(String ... names) {
        this.helper.addIgnoredHeaders(names);
    }

    boolean isSslHostnameValidationEnabled() {
        return this.sslHostnameValidationEnabled;
    }
}

