/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.SmallTagMap;
import com.netflix.servo.tag.Tags;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.metrics.MetricsTagProvider;
import org.springframework.cloud.netflix.metrics.servo.ServoMonitorCache;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class MetricsClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @Autowired
    MonitorRegistry registry;
    @Autowired
    Collection<MetricsTagProvider> tagProviders;
    @Autowired
    ServoMonitorCache servoMonitorCache;
    @Value(value="${netflix.metrics.restClient.metricName:restclient}")
    String metricName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        long startTime = System.nanoTime();
        ClientHttpResponse response = null;
        try {
            ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
            return clientHttpResponse;
        }
        finally {
            SmallTagMap.Builder builder = SmallTagMap.builder();
            for (MetricsTagProvider tagProvider : this.tagProviders) {
                for (Map.Entry<String, String> tag : tagProvider.clientHttpRequestTags(request, response).entrySet()) {
                    builder.add(Tags.newTag((String)tag.getKey(), (String)tag.getValue()));
                }
            }
            MonitorConfig.Builder monitorConfigBuilder = MonitorConfig.builder((String)this.metricName);
            monitorConfigBuilder.withTags(builder);
            this.servoMonitorCache.getTimer(monitorConfigBuilder.build()).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }
}

