/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.support;

import feign.FeignException;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.cloud.netflix.feign.support.FeignUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.HttpMessageConverterExtractor;

public class SpringDecoder
implements Decoder {
    private ObjectFactory<HttpMessageConverters> messageConverters;

    public SpringDecoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        if (type instanceof Class || type instanceof ParameterizedType) {
            HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(type, ((HttpMessageConverters)this.messageConverters.getObject()).getConverters());
            return extractor.extractData((ClientHttpResponse)new FeignResponseAdapter(response));
        }
        throw new DecodeException("type is not an instance of Class or ParameterizedType: " + type);
    }

    private class FeignResponseAdapter
    implements ClientHttpResponse {
        private final Response response;

        private FeignResponseAdapter(Response response) {
            this.response = response;
        }

        public HttpStatus getStatusCode() throws IOException {
            return HttpStatus.valueOf((int)this.response.status());
        }

        public int getRawStatusCode() throws IOException {
            return this.response.status();
        }

        public String getStatusText() throws IOException {
            return this.response.reason();
        }

        public void close() {
            try {
                this.response.body().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public InputStream getBody() throws IOException {
            return this.response.body().asInputStream();
        }

        public HttpHeaders getHeaders() {
            return FeignUtils.getHttpHeaders(this.response.headers());
        }
    }
}

