/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.client.http.HttpRequest;
import com.netflix.niws.client.http.RestClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.zuul.filters.route.RestClientRibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;

public class RestClientRibbonCommandFactory
implements RibbonCommandFactory<RestClientRibbonCommand> {
    private final SpringClientFactory clientFactory;

    public RestClientRibbonCommandFactory(SpringClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public RestClientRibbonCommand create(RibbonCommandContext context) {
        RestClient restClient = this.clientFactory.getClient(context.getServiceId(), RestClient.class);
        return new RestClientRibbonCommand(context.getServiceId(), restClient, RestClientRibbonCommandFactory.getVerb(context.getVerb()), context.getUri(), context.getRetryable(), context.getHeaders(), context.getParams(), context.getRequestEntity());
    }

    protected SpringClientFactory getClientFactory() {
        return this.clientFactory;
    }

    protected static HttpRequest.Verb getVerb(String sMethod) {
        if (sMethod == null) {
            return HttpRequest.Verb.GET;
        }
        try {
            return HttpRequest.Verb.valueOf((String)sMethod.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return HttpRequest.Verb.GET;
        }
    }
}

