/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.netflix.feign.FeignContext;
import org.springframework.cloud.netflix.feign.Targeter;
import org.springframework.cloud.netflix.feign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class FeignClientFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware {
    private Class<?> type;
    private String name;
    private String url;
    private String path;
    private boolean decode404;
    private ApplicationContext applicationContext;
    private Class<?> fallback = Void.TYPE;
    private Class<?> fallbackFactory = Void.TYPE;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.name, (String)"Name must be set");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    protected Feign.Builder feign(FeignContext context) {
        Map requestInterceptors;
        Request.Options options;
        ErrorDecoder errorDecoder;
        Retryer retryer;
        Logger logger = this.getOptional(context, Logger.class);
        if (logger == null) {
            logger = new Slf4jLogger(this.type);
        }
        Feign.Builder builder = this.get(context, Feign.Builder.class).logger(logger).encoder(this.get(context, Encoder.class)).decoder(this.get(context, Decoder.class)).contract(this.get(context, Contract.class));
        Logger.Level level = this.getOptional(context, Logger.Level.class);
        if (level != null) {
            builder.logLevel(level);
        }
        if ((retryer = this.getOptional(context, Retryer.class)) != null) {
            builder.retryer(retryer);
        }
        if ((errorDecoder = this.getOptional(context, ErrorDecoder.class)) != null) {
            builder.errorDecoder(errorDecoder);
        }
        if ((options = this.getOptional(context, Request.Options.class)) != null) {
            builder.options(options);
        }
        if ((requestInterceptors = context.getInstances(this.name, RequestInterceptor.class)) != null) {
            builder.requestInterceptors(requestInterceptors.values());
        }
        if (this.decode404) {
            builder.decode404();
        }
        return builder;
    }

    protected <T> T get(FeignContext context, Class<T> type) {
        Object instance = context.getInstance(this.name, type);
        if (instance == null) {
            throw new IllegalStateException("No bean found of type " + type + " for " + this.name);
        }
        return (T)instance;
    }

    protected <T> T getOptional(FeignContext context, Class<T> type) {
        return (T)context.getInstance(this.name, type);
    }

    protected <T> T loadBalance(Feign.Builder builder, FeignContext context, Target.HardCodedTarget<T> target) {
        Client client = this.getOptional(context, Client.class);
        if (client != null) {
            builder.client(client);
            Targeter targeter = this.get(context, Targeter.class);
            return targeter.target(this, builder, context, target);
        }
        throw new IllegalStateException("No Feign Client for loadBalancing defined. Did you forget to include spring-cloud-starter-ribbon?");
    }

    public Object getObject() throws Exception {
        FeignContext context = (FeignContext)((Object)this.applicationContext.getBean(FeignContext.class));
        Feign.Builder builder = this.feign(context);
        if (!StringUtils.hasText((String)this.url)) {
            String url = !this.name.startsWith("http") ? "http://" + this.name : this.name;
            url = url + this.cleanPath();
            return this.loadBalance(builder, context, new Target.HardCodedTarget(this.type, this.name, url));
        }
        if (StringUtils.hasText((String)this.url) && !this.url.startsWith("http")) {
            this.url = "http://" + this.url;
        }
        String url = this.url + this.cleanPath();
        Client client = this.getOptional(context, Client.class);
        if (client != null) {
            if (client instanceof LoadBalancerFeignClient) {
                client = ((LoadBalancerFeignClient)client).getDelegate();
            }
            builder.client(client);
        }
        Targeter targeter = this.get(context, Targeter.class);
        return targeter.target(this, builder, context, new Target.HardCodedTarget(this.type, this.name, url));
    }

    private String cleanPath() {
        String path = this.path.trim();
        if (StringUtils.hasLength((String)path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isDecode404() {
        return this.decode404;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Class<?> getFallback() {
        return this.fallback;
    }

    public Class<?> getFallbackFactory() {
        return this.fallbackFactory;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDecode404(boolean decode404) {
        this.decode404 = decode404;
    }

    public void setFallback(Class<?> fallback) {
        this.fallback = fallback;
    }

    public void setFallbackFactory(Class<?> fallbackFactory) {
        this.fallbackFactory = fallbackFactory;
    }

    public String toString() {
        return "FeignClientFactoryBean(type=" + this.getType() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", path=" + this.getPath() + ", decode404=" + this.isDecode404() + ", applicationContext=" + this.getApplicationContext() + ", fallback=" + this.getFallback() + ", fallbackFactory=" + this.getFallbackFactory() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeignClientFactoryBean)) {
            return false;
        }
        FeignClientFactoryBean other = (FeignClientFactoryBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.isDecode404() != other.isDecode404()) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        Class<?> this$fallback = this.getFallback();
        Class<?> other$fallback = other.getFallback();
        if (this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback)) {
            return false;
        }
        Class<?> this$fallbackFactory = this.getFallbackFactory();
        Class<?> other$fallbackFactory = other.getFallbackFactory();
        return !(this$fallbackFactory == null ? other$fallbackFactory != null : !this$fallbackFactory.equals(other$fallbackFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeignClientFactoryBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + (this.isDecode404() ? 79 : 97);
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        Class<?> $fallback = this.getFallback();
        result = result * 59 + ($fallback == null ? 43 : $fallback.hashCode());
        Class<?> $fallbackFactory = this.getFallbackFactory();
        result = result * 59 + ($fallbackFactory == null ? 43 : $fallbackFactory.hashCode());
        return result;
    }
}

