/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.client.http.HttpRequest;
import com.netflix.niws.client.http.RestClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.RestClientRibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;

public class RestClientRibbonCommandFactory
implements RibbonCommandFactory<RestClientRibbonCommand> {
    private final SpringClientFactory clientFactory;
    private ZuulProperties zuulProperties;

    public RestClientRibbonCommandFactory(SpringClientFactory clientFactory) {
        this(clientFactory, new ZuulProperties());
    }

    public RestClientRibbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties) {
        this.clientFactory = clientFactory;
        this.zuulProperties = zuulProperties;
    }

    @Override
    public RestClientRibbonCommand create(RibbonCommandContext context) {
        RestClient restClient = this.clientFactory.getClient(context.getServiceId(), RestClient.class);
        return new RestClientRibbonCommand(context.getServiceId(), restClient, context, this.zuulProperties);
    }

    public SpringClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public void setZuulProperties(ZuulProperties zuulProperties) {
        this.zuulProperties = zuulProperties;
    }

    protected static HttpRequest.Verb getVerb(String method) {
        return RestClientRibbonCommand.getVerb(method);
    }
}

