/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import com.netflix.loadbalancer.ILoadBalancer;
import feign.Client;
import feign.Feign;
import feign.Request;
import feign.httpclient.ApacheHttpClient;
import okhttp3.OkHttpClient;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.feign.FeignAutoConfiguration;
import org.springframework.cloud.netflix.feign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.netflix.feign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@ConditionalOnClass(value={ILoadBalancer.class, Feign.class})
@Configuration
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
public class FeignRibbonClientAutoConfiguration {
    @Bean
    @Primary
    public CachingSpringLoadBalancerFactory cachingLBClientFactory(SpringClientFactory factory) {
        return new CachingSpringLoadBalancerFactory(factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory) {
        return new LoadBalancerFeignClient((Client)new Client.Default(null, null), cachingFactory, clientFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public Request.Options feignRequestOptions() {
        return LoadBalancerFeignClient.DEFAULT_OPTIONS;
    }

    @Configuration
    @ConditionalOnClass(value={feign.okhttp.OkHttpClient.class})
    @ConditionalOnProperty(value={"feign.okhttp.enabled"}, matchIfMissing=true)
    protected static class OkHttpFeignLoadBalancedConfiguration {
        @Autowired(required=false)
        private OkHttpClient okHttpClient;

        protected OkHttpFeignLoadBalancedConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory) {
            feign.okhttp.OkHttpClient delegate = this.okHttpClient != null ? new feign.okhttp.OkHttpClient(this.okHttpClient) : new feign.okhttp.OkHttpClient();
            return new LoadBalancerFeignClient((Client)delegate, cachingFactory, clientFactory);
        }
    }

    @Configuration
    @ConditionalOnClass(value={ApacheHttpClient.class})
    @ConditionalOnProperty(value={"feign.httpclient.enabled"}, matchIfMissing=true)
    protected static class HttpClientFeignLoadBalancedConfiguration {
        @Autowired(required=false)
        private HttpClient httpClient;

        protected HttpClientFeignLoadBalancedConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Client.class})
        public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory) {
            ApacheHttpClient delegate = this.httpClient != null ? new ApacheHttpClient(this.httpClient) : new ApacheHttpClient();
            return new LoadBalancerFeignClient((Client)delegate, cachingFactory, clientFactory);
        }
    }
}

