/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class WebClientEurekaHttpClient
implements EurekaHttpClient {
    private WebClient webClient;

    public WebClientEurekaHttpClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        return (EurekaHttpResponse)((WebClient.RequestBodySpec)this.webClient.post().uri(uriBuilder -> uriBuilder.path("apps/{appName}").build(new Object[]{info.getAppName()}))).body(BodyInserters.fromValue((Object)info)).header("Accept-Encoding", new String[]{"gzip"}).header("Content-Type", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toBodilessEntity().map(this::eurekaHttpResponse).block();
    }

    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        return (EurekaHttpResponse)this.webClient.delete().uri(uriBuilder -> uriBuilder.path("apps/{appName}/{id}").build(new Object[]{appName, id})).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toBodilessEntity().map(this::eurekaHttpResponse).block();
    }

    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        ResponseEntity response = (ResponseEntity)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.put().uri(uriBuilder -> uriBuilder.path("apps/{appName}/{id}").queryParam("status", new Object[]{info.getStatus().toString()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).build(new Object[]{appName, id}))).header("Content-Type", new String[]{"application/json"})).header("Accept", new String[]{"application/json"})).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toEntity(InstanceInfo.class).block();
        EurekaHttpResponse.EurekaHttpResponseBuilder builder = EurekaHttpResponse.anEurekaHttpResponse((int)this.statusCodeValueOf(response), InstanceInfo.class).headers(WebClientEurekaHttpClient.headersOf(response));
        InstanceInfo entity = (InstanceInfo)response.getBody();
        if (entity != null) {
            builder.entity((Object)entity);
        }
        return builder.build();
    }

    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        return (EurekaHttpResponse)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.put().uri(uriBuilder -> uriBuilder.path("apps/{appName}/{id}/status").queryParam("value", new Object[]{newStatus.name()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).build(new Object[]{appName, id}))).header("Content-Type", new String[]{"application/json"})).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toBodilessEntity().map(this::eurekaHttpResponse).block();
    }

    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        return (EurekaHttpResponse)this.webClient.delete().uri(uriBuilder -> uriBuilder.path("apps/{appName}/{id}/status").queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).build(new Object[]{appName, id})).header("Content-Type", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toBodilessEntity().map(this::eurekaHttpResponse).block();
    }

    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("apps/", regions);
    }

    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        Optional regionsParam = regions != null && regions.length > 0 ? Optional.of(StringUtil.join((String[])regions)) : Optional.empty();
        ResponseEntity response = (ResponseEntity)this.webClient.get().uri(uriBuilder -> uriBuilder.path(urlPath).queryParamIfPresent("regions", regionsParam).build(new Object[0])).header("Content-Type", new String[]{"application/json"}).header("Accept", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toEntity(Applications.class).block();
        int statusCode = this.statusCodeValueOf(response);
        Applications body = (Applications)response.getBody();
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, statusCode == HttpStatus.OK.value() && body != null ? body : null).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("apps/delta", regions);
    }

    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("vips/" + vipAddress, regions);
    }

    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("svips/" + secureVipAddress, regions);
    }

    public EurekaHttpResponse<Application> getApplication(String appName) {
        ResponseEntity response = (ResponseEntity)this.webClient.get().uri(uriBuilder -> uriBuilder.path("apps/{appName}").build(new Object[]{appName})).header("Accept", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toEntity(Application.class).block();
        int statusCode = this.statusCodeValueOf(response);
        Application body = (Application)response.getBody();
        Application application = statusCode == HttpStatus.OK.value() && body != null ? body : null;
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, (Object)application).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("apps", appName, id);
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("instances", id);
    }

    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String ... pathSegments) {
        ResponseEntity response = (ResponseEntity)this.webClient.get().uri(uriBuilder -> uriBuilder.pathSegment(pathSegments).build(new Object[0])).header("Accept", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toEntity(InstanceInfo.class).block();
        int statusCode = this.statusCodeValueOf(response);
        InstanceInfo body = (InstanceInfo)response.getBody();
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, statusCode == HttpStatus.OK.value() && body != null ? body : null).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    public void shutdown() {
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    private Mono<? extends Throwable> ignoreError(ClientResponse response) {
        return Mono.empty();
    }

    private static Map<String, String> headersOf(ResponseEntity<?> response) {
        return response.getHeaders().toSingleValueMap();
    }

    private int statusCodeValueOf(ResponseEntity<?> response) {
        return response.getStatusCode().value();
    }

    private EurekaHttpResponse<Void> eurekaHttpResponse(ResponseEntity<?> response) {
        return EurekaHttpResponse.anEurekaHttpResponse((int)this.statusCodeValueOf(response)).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }
}

