/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="turbine")
public class TurbineProperties {
    private String clusterNameExpression;
    private String appConfig;
    private boolean combineHostPort = false;

    public List<String> getAppConfigList() {
        if (!StringUtils.hasText((String)this.appConfig)) {
            return null;
        }
        String[] parts = StringUtils.commaDelimitedListToStringArray((String)this.appConfig);
        if (parts != null && parts.length > 0) {
            parts = StringUtils.trimArrayElements((String[])parts);
            return Arrays.asList(parts);
        }
        return null;
    }

    public String getClusterNameExpression() {
        return this.clusterNameExpression;
    }

    public String getAppConfig() {
        return this.appConfig;
    }

    public boolean isCombineHostPort() {
        return this.combineHostPort;
    }

    public void setClusterNameExpression(String clusterNameExpression) {
        this.clusterNameExpression = clusterNameExpression;
    }

    public void setAppConfig(String appConfig) {
        this.appConfig = appConfig;
    }

    public void setCombineHostPort(boolean combineHostPort) {
        this.combineHostPort = combineHostPort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TurbineProperties)) {
            return false;
        }
        TurbineProperties other = (TurbineProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clusterNameExpression = this.getClusterNameExpression();
        String other$clusterNameExpression = other.getClusterNameExpression();
        if (this$clusterNameExpression == null ? other$clusterNameExpression != null : !this$clusterNameExpression.equals(other$clusterNameExpression)) {
            return false;
        }
        String this$appConfig = this.getAppConfig();
        String other$appConfig = other.getAppConfig();
        if (this$appConfig == null ? other$appConfig != null : !this$appConfig.equals(other$appConfig)) {
            return false;
        }
        return this.isCombineHostPort() == other.isCombineHostPort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TurbineProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clusterNameExpression = this.getClusterNameExpression();
        result = result * 59 + ($clusterNameExpression == null ? 43 : $clusterNameExpression.hashCode());
        String $appConfig = this.getAppConfig();
        result = result * 59 + ($appConfig == null ? 43 : $appConfig.hashCode());
        result = result * 59 + (this.isCombineHostPort() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TurbineProperties(clusterNameExpression=" + this.getClusterNameExpression() + ", appConfig=" + this.getAppConfig() + ", combineHostPort=" + this.isCombineHostPort() + ")";
    }
}

