/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Client;
import feign.Contract;
import feign.ExceptionPropagationPolicy;
import feign.Feign;
import feign.Logger;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.FeignErrorDecoderFactory;
import org.springframework.cloud.openfeign.FeignLoggerFactory;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.cloud.openfeign.clientconfig.FeignClientConfigurer;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class FeignClientFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware {
    private Class<?> type;
    private String name;
    private String url;
    private String contextId;
    private String path;
    private boolean decode404;
    private boolean inheritParentContext = true;
    private ApplicationContext applicationContext;
    private Class<?> fallback = Void.TYPE;
    private Class<?> fallbackFactory = Void.TYPE;

    FeignClientFactoryBean() {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.contextId, (String)"Context id must be set");
        Assert.hasText((String)this.name, (String)"Name must be set");
    }

    protected Feign.Builder feign(FeignContext context) {
        FeignLoggerFactory loggerFactory = this.get(context, FeignLoggerFactory.class);
        Logger logger = loggerFactory.create(this.type);
        Feign.Builder builder = this.get(context, Feign.Builder.class).logger(logger).encoder(this.get(context, Encoder.class)).decoder(this.get(context, Decoder.class)).contract(this.get(context, Contract.class));
        this.configureFeign(context, builder);
        return builder;
    }

    protected void configureFeign(FeignContext context, Feign.Builder builder) {
        FeignClientProperties properties = (FeignClientProperties)this.applicationContext.getBean(FeignClientProperties.class);
        FeignClientConfigurer feignClientConfigurer = this.getOptional(context, FeignClientConfigurer.class);
        this.setInheritParentContext(feignClientConfigurer.inheritParentConfiguration());
        if (properties != null && this.inheritParentContext) {
            if (properties.isDefaultToProperties()) {
                this.configureUsingConfiguration(context, builder);
                this.configureUsingProperties(properties.getConfig().get(properties.getDefaultConfig()), builder);
                this.configureUsingProperties(properties.getConfig().get(this.contextId), builder);
            } else {
                this.configureUsingProperties(properties.getConfig().get(properties.getDefaultConfig()), builder);
                this.configureUsingProperties(properties.getConfig().get(this.contextId), builder);
                this.configureUsingConfiguration(context, builder);
            }
        } else {
            this.configureUsingConfiguration(context, builder);
        }
    }

    protected void configureUsingConfiguration(FeignContext context, Feign.Builder builder) {
        ExceptionPropagationPolicy exceptionPropagationPolicy;
        QueryMapEncoder queryMapEncoder;
        Map<String, RequestInterceptor> requestInterceptors;
        ErrorDecoder errorDecoder;
        Retryer retryer;
        Logger.Level level = this.getInheritedAwareOptional(context, Logger.Level.class);
        if (level != null) {
            builder.logLevel(level);
        }
        if ((retryer = this.getInheritedAwareOptional(context, Retryer.class)) != null) {
            builder.retryer(retryer);
        }
        if ((errorDecoder = this.getInheritedAwareOptional(context, ErrorDecoder.class)) != null) {
            builder.errorDecoder(errorDecoder);
        } else {
            FeignErrorDecoderFactory errorDecoderFactory = this.getOptional(context, FeignErrorDecoderFactory.class);
            if (errorDecoderFactory != null) {
                ErrorDecoder factoryErrorDecoder = errorDecoderFactory.create(this.type);
                builder.errorDecoder(factoryErrorDecoder);
            }
        }
        Request.Options options = this.getInheritedAwareOptional(context, Request.Options.class);
        if (options != null) {
            builder.options(options);
        }
        if ((requestInterceptors = this.getInheritedAwareInstances(context, RequestInterceptor.class)) != null) {
            builder.requestInterceptors(requestInterceptors.values());
        }
        if ((queryMapEncoder = this.getInheritedAwareOptional(context, QueryMapEncoder.class)) != null) {
            builder.queryMapEncoder(queryMapEncoder);
        }
        if (this.decode404) {
            builder.decode404();
        }
        if ((exceptionPropagationPolicy = this.getInheritedAwareOptional(context, ExceptionPropagationPolicy.class)) != null) {
            builder.exceptionPropagationPolicy(exceptionPropagationPolicy);
        }
    }

    protected void configureUsingProperties(FeignClientProperties.FeignClientConfiguration config, Feign.Builder builder) {
        if (config == null) {
            return;
        }
        if (config.getLoggerLevel() != null) {
            builder.logLevel(config.getLoggerLevel());
        }
        if (config.getConnectTimeout() != null && config.getReadTimeout() != null) {
            builder.options(new Request.Options(config.getConnectTimeout().intValue(), config.getReadTimeout().intValue()));
        }
        if (config.getRetryer() != null) {
            Retryer retryer = this.getOrInstantiate(config.getRetryer());
            builder.retryer(retryer);
        }
        if (config.getErrorDecoder() != null) {
            ErrorDecoder errorDecoder = this.getOrInstantiate(config.getErrorDecoder());
            builder.errorDecoder(errorDecoder);
        }
        if (config.getRequestInterceptors() != null && !config.getRequestInterceptors().isEmpty()) {
            for (Class<RequestInterceptor> bean : config.getRequestInterceptors()) {
                RequestInterceptor interceptor = this.getOrInstantiate(bean);
                builder.requestInterceptor(interceptor);
            }
        }
        if (config.getDecode404() != null && config.getDecode404().booleanValue()) {
            builder.decode404();
        }
        if (Objects.nonNull(config.getEncoder())) {
            builder.encoder(this.getOrInstantiate(config.getEncoder()));
        }
        if (Objects.nonNull(config.getDecoder())) {
            builder.decoder(this.getOrInstantiate(config.getDecoder()));
        }
        if (Objects.nonNull(config.getContract())) {
            builder.contract(this.getOrInstantiate(config.getContract()));
        }
        if (Objects.nonNull(config.getExceptionPropagationPolicy())) {
            builder.exceptionPropagationPolicy(config.getExceptionPropagationPolicy());
        }
    }

    private <T> T getOrInstantiate(Class<T> tClass) {
        try {
            return (T)this.applicationContext.getBean(tClass);
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)BeanUtils.instantiateClass(tClass);
        }
    }

    protected <T> T get(FeignContext context, Class<T> type) {
        Object instance = context.getInstance(this.contextId, type);
        if (instance == null) {
            throw new IllegalStateException("No bean found of type " + type + " for " + this.contextId);
        }
        return (T)instance;
    }

    protected <T> T getOptional(FeignContext context, Class<T> type) {
        return (T)context.getInstance(this.contextId, type);
    }

    protected <T> T getInheritedAwareOptional(FeignContext context, Class<T> type) {
        if (this.inheritParentContext) {
            return this.getOptional(context, type);
        }
        return context.getInstanceWithoutAncestors(this.contextId, type);
    }

    protected <T> Map<String, T> getInheritedAwareInstances(FeignContext context, Class<T> type) {
        if (this.inheritParentContext) {
            return context.getInstances(this.contextId, type);
        }
        return context.getInstancesWithoutAncestors(this.contextId, type);
    }

    protected <T> T loadBalance(Feign.Builder builder, FeignContext context, Target.HardCodedTarget<T> target) {
        Client client = this.getOptional(context, Client.class);
        if (client != null) {
            builder.client(client);
            Targeter targeter = this.get(context, Targeter.class);
            return targeter.target(this, builder, context, target);
        }
        throw new IllegalStateException("No Feign Client for loadBalancing defined. Did you forget to include spring-cloud-starter-netflix-ribbon?");
    }

    public Object getObject() throws Exception {
        return this.getTarget();
    }

    <T> T getTarget() {
        FeignContext context = (FeignContext)((Object)this.applicationContext.getBean(FeignContext.class));
        Feign.Builder builder = this.feign(context);
        if (!StringUtils.hasText((String)this.url)) {
            this.url = !this.name.startsWith("http") ? "http://" + this.name : this.name;
            this.url = this.url + this.cleanPath();
            return this.loadBalance(builder, context, new Target.HardCodedTarget(this.type, this.name, this.url));
        }
        if (StringUtils.hasText((String)this.url) && !this.url.startsWith("http")) {
            this.url = "http://" + this.url;
        }
        String url = this.url + this.cleanPath();
        Client client = this.getOptional(context, Client.class);
        if (client != null) {
            if (client instanceof LoadBalancerFeignClient) {
                client = ((LoadBalancerFeignClient)client).getDelegate();
            }
            if (client instanceof FeignBlockingLoadBalancerClient) {
                client = ((FeignBlockingLoadBalancerClient)client).getDelegate();
            }
            builder.client(client);
        }
        Targeter targeter = this.get(context, Targeter.class);
        return targeter.target(this, builder, context, new Target.HardCodedTarget(this.type, this.name, url));
    }

    private String cleanPath() {
        String path = this.path.trim();
        if (StringUtils.hasLength((String)path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDecode404() {
        return this.decode404;
    }

    public void setDecode404(boolean decode404) {
        this.decode404 = decode404;
    }

    public boolean isInheritParentContext() {
        return this.inheritParentContext;
    }

    public void setInheritParentContext(boolean inheritParentContext) {
        this.inheritParentContext = inheritParentContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    public Class<?> getFallback() {
        return this.fallback;
    }

    public void setFallback(Class<?> fallback) {
        this.fallback = fallback;
    }

    public Class<?> getFallbackFactory() {
        return this.fallbackFactory;
    }

    public void setFallbackFactory(Class<?> fallbackFactory) {
        this.fallbackFactory = fallbackFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeignClientFactoryBean that = (FeignClientFactoryBean)o;
        return Objects.equals(this.applicationContext, that.applicationContext) && this.decode404 == that.decode404 && this.inheritParentContext == that.inheritParentContext && Objects.equals(this.fallback, that.fallback) && Objects.equals(this.fallbackFactory, that.fallbackFactory) && Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path) && Objects.equals(this.type, that.type) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.applicationContext, this.decode404, this.inheritParentContext, this.fallback, this.fallbackFactory, this.name, this.path, this.type, this.url);
    }

    public String toString() {
        return "FeignClientFactoryBean{" + "type=" + this.type + ", " + "name='" + this.name + "', " + "url='" + this.url + "', " + "path='" + this.path + "', " + "decode404=" + this.decode404 + ", " + "inheritParentContext=" + this.inheritParentContext + ", " + "applicationContext=" + this.applicationContext + ", " + "fallback=" + this.fallback + ", " + "fallbackFactory=" + this.fallbackFactory + "}";
    }
}

