/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.loadbalancer;

import feign.Client;
import feign.httpclient.ApacheHttpClient;
import org.apache.http.client.HttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.clientconfig.HttpClientFeignConfiguration;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ApacheHttpClient.class})
@ConditionalOnBean(value={BlockingLoadBalancerClient.class})
@ConditionalOnProperty(value={"feign.httpclient.enabled"}, matchIfMissing=true)
@Import(value={HttpClientFeignConfiguration.class})
class HttpClientFeignLoadBalancerConfiguration {
    HttpClientFeignLoadBalancerConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public Client feignClient(BlockingLoadBalancerClient loadBalancerClient, HttpClient httpClient) {
        ApacheHttpClient delegate = new ApacheHttpClient(httpClient);
        return new FeignBlockingLoadBalancerClient((Client)delegate, loadBalancerClient);
    }
}

