/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.hateoas;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.rest.RepositoryRestMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.hateoas.HypermediaAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.DefaultCurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@ConditionalOnClass(value={RepresentationModel.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, RepositoryRestMvcAutoConfiguration.class})
@AutoConfigureBefore(value={HypermediaAutoConfiguration.class})
public class FeignHalAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TypeConstrainedMappingJackson2HttpMessageConverter halJacksonHttpMessageConverter(ObjectProvider<ObjectMapper> objectMapper, ObjectProvider<HalConfiguration> halConfiguration, ObjectProvider<MessageResolver> messageResolver, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<LinkRelationProvider> linkRelationProvider) {
        ObjectMapper mapper = ((ObjectMapper)objectMapper.getIfAvailable(ObjectMapper::new)).copy();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        HalConfiguration configuration = (HalConfiguration)halConfiguration.getIfAvailable(HalConfiguration::new);
        CurieProvider curieProviderInstance = (CurieProvider)curieProvider.getIfAvailable(() -> new DefaultCurieProvider(Collections.emptyMap()));
        Jackson2HalModule.HalHandlerInstantiator halHandlerInstantiator = new Jackson2HalModule.HalHandlerInstantiator((LinkRelationProvider)linkRelationProvider.getIfAvailable(), curieProviderInstance, (MessageResolver)messageResolver.getIfAvailable(), configuration);
        mapper.setHandlerInstantiator((HandlerInstantiator)halHandlerInstantiator);
        if (!Jackson2HalModule.isAlreadyRegisteredIn((ObjectMapper)mapper)) {
            Jackson2HalModule halModule = new Jackson2HalModule();
            mapper.registerModule((Module)halModule);
        }
        TypeConstrainedMappingJackson2HttpMessageConverter converter = new TypeConstrainedMappingJackson2HttpMessageConverter(RepresentationModel.class);
        converter.setSupportedMediaTypes(Arrays.asList(MediaTypes.HAL_JSON));
        converter.setObjectMapper(mapper);
        return converter;
    }
}

