/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.Contract;
import feign.Feign;
import feign.MethodMetadata;
import feign.Param;
import feign.Request;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.CollectionFormat;
import org.springframework.cloud.openfeign.annotation.MatrixVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.PathVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.QueryMapParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestHeaderParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestParamParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestPartParameterProcessor;
import org.springframework.cloud.openfeign.support.FeignUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringMvcContract
extends Contract.BaseContract
implements ResourceLoaderAware {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor ITERABLE_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Iterable.class);
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Map<Class<? extends Annotation>, AnnotatedParameterProcessor> annotatedArgumentProcessors;
    private final Map<String, Method> processedMethods = new HashMap<String, Method>();
    private final ConversionService conversionService;
    private final ConvertingExpanderFactory convertingExpanderFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public SpringMvcContract() {
        this(Collections.emptyList());
    }

    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors) {
        this(annotatedParameterProcessors, (ConversionService)new DefaultConversionService());
    }

    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService) {
        Assert.notNull(annotatedParameterProcessors, (String)"Parameter processors can not be null.");
        Assert.notNull((Object)conversionService, (String)"ConversionService can not be null.");
        List<AnnotatedParameterProcessor> processors = this.getDefaultAnnotatedArgumentsProcessors();
        processors.addAll(annotatedParameterProcessors);
        this.annotatedArgumentProcessors = this.toAnnotatedArgumentProcessorMap(processors);
        this.conversionService = conversionService;
        this.convertingExpanderFactory = new ConvertingExpanderFactory(conversionService);
    }

    private static TypeDescriptor createTypeDescriptor(Method method, int paramIndex) {
        Parameter parameter = method.getParameters()[paramIndex];
        MethodParameter methodParameter = MethodParameter.forParameter((Parameter)parameter);
        TypeDescriptor typeDescriptor = new TypeDescriptor(methodParameter);
        if (typeDescriptor.isAssignableTo(ITERABLE_TYPE_DESCRIPTOR)) {
            TypeDescriptor elementTypeDescriptor = SpringMvcContract.getElementTypeDescriptor(typeDescriptor);
            Util.checkState((elementTypeDescriptor != null ? 1 : 0) != 0, (String)"Could not resolve element type of Iterable type %s. Not declared?", (Object[])new Object[]{typeDescriptor});
            typeDescriptor = elementTypeDescriptor;
        }
        return typeDescriptor;
    }

    private static TypeDescriptor getElementTypeDescriptor(TypeDescriptor typeDescriptor) {
        TypeDescriptor elementTypeDescriptor = typeDescriptor.getElementTypeDescriptor();
        if (elementTypeDescriptor == null && Iterable.class.isAssignableFrom(typeDescriptor.getType())) {
            ResolvableType type = typeDescriptor.getResolvableType().as(Iterable.class).getGeneric(new int[]{0});
            if (type.resolve() == null) {
                return null;
            }
            return new TypeDescriptor(type, null, typeDescriptor.getAnnotations());
        }
        return elementTypeDescriptor;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected void processAnnotationOnClass(MethodMetadata data, Class<?> clz) {
        RequestMapping classAnnotation;
        if (clz.getInterfaces().length == 0 && (classAnnotation = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(clz, RequestMapping.class)) != null && classAnnotation.value().length > 0) {
            String pathValue = Util.emptyToNull((String)classAnnotation.value()[0]);
            if (!(pathValue = this.resolve(pathValue)).startsWith("/")) {
                pathValue = "/" + pathValue;
            }
            data.template().uri(pathValue);
        }
    }

    public MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        this.processedMethods.put(Feign.configKey(targetType, (Method)method), method);
        MethodMetadata md = super.parseAndValidateMetadata(targetType, method);
        RequestMapping classAnnotation = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(targetType, RequestMapping.class);
        if (classAnnotation != null) {
            if (!md.template().headers().containsKey(ACCEPT)) {
                this.parseProduces(md, method, classAnnotation);
            }
            if (!md.template().headers().containsKey(CONTENT_TYPE)) {
                this.parseConsumes(md, method, classAnnotation);
            }
            this.parseHeaders(md, method, classAnnotation);
        }
        return md;
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        String pathValue;
        if (CollectionFormat.class.isInstance(methodAnnotation)) {
            CollectionFormat collectionFormat = (CollectionFormat)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CollectionFormat.class);
            data.template().collectionFormat(collectionFormat.value());
        }
        if (!RequestMapping.class.isInstance(methodAnnotation) && !methodAnnotation.annotationType().isAnnotationPresent(RequestMapping.class)) {
            return;
        }
        RequestMapping methodMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        Object[] methods = methodMapping.method();
        if (methods.length == 0) {
            methods = new RequestMethod[]{RequestMethod.GET};
        }
        this.checkOne(method, methods, "method");
        data.template().method(Request.HttpMethod.valueOf((String)methods[0].name()));
        this.checkAtMostOne(method, methodMapping.value(), "value");
        if (methodMapping.value().length > 0 && (pathValue = Util.emptyToNull((String)methodMapping.value()[0])) != null) {
            if (!(pathValue = this.resolve(pathValue)).startsWith("/") && !data.template().path().endsWith("/")) {
                pathValue = "/" + pathValue;
            }
            data.template().uri(pathValue, true);
        }
        this.parseProduces(data, method, methodMapping);
        this.parseConsumes(data, method, methodMapping);
        this.parseHeaders(data, method, methodMapping);
        data.indexToExpander(new LinkedHashMap());
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value) && this.resourceLoader instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)this.resourceLoader).getEnvironment().resolvePlaceholders(value);
        }
        return value;
    }

    private void checkAtMostOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && (values.length == 0 || values.length == 1) ? 1 : 0) != 0, (String)"Method %s can only contain at most 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private void checkOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && values.length == 1 ? 1 : 0) != 0, (String)"Method %s can only contain 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        Param.Expander expander;
        TypeDescriptor typeDescriptor;
        boolean isHttpAnnotation = false;
        SimpleAnnotatedParameterContext context = new SimpleAnnotatedParameterContext(data, paramIndex);
        Method method = this.processedMethods.get(data.configKey());
        for (Annotation parameterAnnotation : annotations) {
            AnnotatedParameterProcessor processor = this.annotatedArgumentProcessors.get(parameterAnnotation.annotationType());
            if (processor == null) continue;
            Annotation processParameterAnnotation = this.synthesizeWithMethodParameterNameAsFallbackValue(parameterAnnotation, method, paramIndex);
            isHttpAnnotation |= processor.processArgument(context, processParameterAnnotation, method);
        }
        if (!this.isMultipartFormData(data) && isHttpAnnotation && data.indexToExpander().get(paramIndex) == null && this.conversionService.canConvert(typeDescriptor = SpringMvcContract.createTypeDescriptor(method, paramIndex), STRING_TYPE_DESCRIPTOR) && (expander = this.convertingExpanderFactory.getExpander(typeDescriptor)) != null) {
            data.indexToExpander().put(paramIndex, expander);
        }
        return isHttpAnnotation;
    }

    private void parseProduces(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientAccepts;
        String[] serverProduces = annotation.produces();
        String string = clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
        if (clientAccepts != null) {
            md.template().header(ACCEPT, new String[]{clientAccepts});
        }
    }

    private void parseConsumes(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientProduces;
        String[] serverConsumes = annotation.consumes();
        String string = clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
        if (clientProduces != null) {
            md.template().header(CONTENT_TYPE, new String[]{clientProduces});
        }
    }

    private void parseHeaders(MethodMetadata md, Method method, RequestMapping annotation) {
        if (annotation.headers() != null && annotation.headers().length > 0) {
            for (String header : annotation.headers()) {
                int index = header.indexOf(61);
                if (header.contains("!=") || index < 0) continue;
                md.template().header(this.resolve(header.substring(0, index)), new String[]{this.resolve(header.substring(index + 1).trim())});
            }
        }
    }

    private Map<Class<? extends Annotation>, AnnotatedParameterProcessor> toAnnotatedArgumentProcessorMap(List<AnnotatedParameterProcessor> processors) {
        HashMap<Class<? extends Annotation>, AnnotatedParameterProcessor> result = new HashMap<Class<? extends Annotation>, AnnotatedParameterProcessor>();
        for (AnnotatedParameterProcessor processor : processors) {
            result.put(processor.getAnnotationType(), processor);
        }
        return result;
    }

    private List<AnnotatedParameterProcessor> getDefaultAnnotatedArgumentsProcessors() {
        ArrayList<AnnotatedParameterProcessor> annotatedArgumentResolvers = new ArrayList<AnnotatedParameterProcessor>();
        annotatedArgumentResolvers.add(new MatrixVariableParameterProcessor());
        annotatedArgumentResolvers.add(new PathVariableParameterProcessor());
        annotatedArgumentResolvers.add(new RequestParamParameterProcessor());
        annotatedArgumentResolvers.add(new RequestHeaderParameterProcessor());
        annotatedArgumentResolvers.add(new QueryMapParameterProcessor());
        annotatedArgumentResolvers.add(new RequestPartParameterProcessor());
        return annotatedArgumentResolvers;
    }

    private Annotation synthesizeWithMethodParameterNameAsFallbackValue(Annotation parameterAnnotation, Method method, int parameterIndex) {
        String[] parameterNames;
        Type[] parameterTypes;
        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)parameterAnnotation);
        Object defaultValue = AnnotationUtils.getDefaultValue((Annotation)parameterAnnotation);
        if (defaultValue instanceof String && defaultValue.equals(annotationAttributes.get("value")) && this.shouldAddParameterName(parameterIndex, parameterTypes = method.getGenericParameterTypes(), parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(method))) {
            annotationAttributes.put("value", parameterNames[parameterIndex]);
        }
        return AnnotationUtils.synthesizeAnnotation((Map)annotationAttributes, parameterAnnotation.annotationType(), null);
    }

    private boolean shouldAddParameterName(int parameterIndex, Type[] parameterTypes, String[] parameterNames) {
        return parameterNames != null && parameterNames.length > parameterIndex && parameterTypes != null && parameterTypes.length > parameterIndex;
    }

    private boolean isMultipartFormData(MethodMetadata data) {
        Collection contentTypes = (Collection)data.template().headers().get(CONTENT_TYPE);
        if (contentTypes != null && !contentTypes.isEmpty()) {
            String type = (String)contentTypes.iterator().next();
            return Objects.equals(MediaType.valueOf((String)type), MediaType.MULTIPART_FORM_DATA);
        }
        return false;
    }

    private class SimpleAnnotatedParameterContext
    implements AnnotatedParameterProcessor.AnnotatedParameterContext {
        private final MethodMetadata methodMetadata;
        private final int parameterIndex;

        SimpleAnnotatedParameterContext(MethodMetadata methodMetadata, int parameterIndex) {
            this.methodMetadata = methodMetadata;
            this.parameterIndex = parameterIndex;
        }

        @Override
        public MethodMetadata getMethodMetadata() {
            return this.methodMetadata;
        }

        @Override
        public int getParameterIndex() {
            return this.parameterIndex;
        }

        @Override
        public void setParameterName(String name) {
            SpringMvcContract.this.nameParam(this.methodMetadata, name, this.parameterIndex);
        }

        @Override
        public Collection<String> setTemplateParameter(String name, Collection<String> rest) {
            return FeignUtils.addTemplateParameter(rest, name);
        }
    }

    private static class ConvertingExpanderFactory {
        private final ConversionService conversionService;

        ConvertingExpanderFactory(ConversionService conversionService) {
            this.conversionService = conversionService;
        }

        Param.Expander getExpander(TypeDescriptor typeDescriptor) {
            return value -> {
                Object converted = this.conversionService.convert(value, typeDescriptor, STRING_TYPE_DESCRIPTOR);
                return (String)converted;
            };
        }
    }

    @Deprecated
    public static class ConvertingExpander
    implements Param.Expander {
        private final ConversionService conversionService;

        public ConvertingExpander(ConversionService conversionService) {
            this.conversionService = conversionService;
        }

        public String expand(Object value) {
            return (String)this.conversionService.convert(value, String.class);
        }
    }
}

