/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.loadbalancer;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.LoadBalancerUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class FeignBlockingLoadBalancerClient
implements Client {
    private static final Log LOG = LogFactory.getLog(FeignBlockingLoadBalancerClient.class);
    private final Client delegate;
    private final LoadBalancerClient loadBalancerClient;
    private final LoadBalancerClientFactory loadBalancerClientFactory;

    @Deprecated
    public FeignBlockingLoadBalancerClient(Client delegate, LoadBalancerClient loadBalancerClient, LoadBalancerProperties properties, LoadBalancerClientFactory loadBalancerClientFactory) {
        this.delegate = delegate;
        this.loadBalancerClient = loadBalancerClient;
        this.loadBalancerClientFactory = loadBalancerClientFactory;
    }

    public FeignBlockingLoadBalancerClient(Client delegate, LoadBalancerClient loadBalancerClient, LoadBalancerClientFactory loadBalancerClientFactory) {
        this.delegate = delegate;
        this.loadBalancerClient = loadBalancerClient;
        this.loadBalancerClientFactory = loadBalancerClientFactory;
    }

    public Response execute(feign.Request request, Request.Options options) throws IOException {
        URI originalUri = URI.create(request.url());
        String serviceId = originalUri.getHost();
        Assert.state((serviceId != null ? 1 : 0) != 0, (String)("Request URI does not contain a valid hostname: " + originalUri));
        String hint = this.getHint(serviceId);
        DefaultRequest lbRequest = new DefaultRequest((Object)new RequestDataContext(LoadBalancerUtils.buildRequestData(request), hint));
        Set supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors((Map)this.loadBalancerClientFactory.getInstances(serviceId, LoadBalancerLifecycle.class), RequestDataContext.class, ResponseData.class, ServiceInstance.class);
        supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart((Request)lbRequest));
        ServiceInstance instance = this.loadBalancerClient.choose(serviceId, (Request)lbRequest);
        DefaultResponse lbResponse = new DefaultResponse(instance);
        if (instance == null) {
            String message = "Load balancer does not contain an instance for the service " + serviceId;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)message);
            }
            supportedLifecycleProcessors.forEach(arg_0 -> FeignBlockingLoadBalancerClient.lambda$execute$1(lbRequest, (org.springframework.cloud.client.loadbalancer.Response)lbResponse, arg_0));
            return Response.builder().request(request).status(HttpStatus.SERVICE_UNAVAILABLE.value()).body(message, StandardCharsets.UTF_8).build();
        }
        String reconstructedUrl = this.loadBalancerClient.reconstructURI(instance, originalUri).toString();
        feign.Request newRequest = this.buildRequest(request, reconstructedUrl);
        return LoadBalancerUtils.executeWithLoadBalancerLifecycleProcessing(this.delegate, options, newRequest, (Request)lbRequest, (org.springframework.cloud.client.loadbalancer.Response<ServiceInstance>)lbResponse, supportedLifecycleProcessors);
    }

    protected feign.Request buildRequest(feign.Request request, String reconstructedUrl) {
        return feign.Request.create((Request.HttpMethod)request.httpMethod(), (String)reconstructedUrl, (Map)request.headers(), (byte[])request.body(), (Charset)request.charset(), (RequestTemplate)request.requestTemplate());
    }

    public Client getDelegate() {
        return this.delegate;
    }

    private String getHint(String serviceId) {
        LoadBalancerProperties properties = this.loadBalancerClientFactory.getProperties(serviceId);
        String defaultHint = properties.getHint().getOrDefault("default", "default");
        String hintPropertyValue = (String)properties.getHint().get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }

    private static /* synthetic */ void lambda$execute$1(DefaultRequest lbRequest, org.springframework.cloud.client.loadbalancer.Response lbResponse, LoadBalancerLifecycle lifecycle) {
        lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, (Request)lbRequest, lbResponse));
    }
}

