/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="feign.httpclient")
public class FeignHttpClientProperties {
    public static final boolean DEFAULT_DISABLE_SSL_VALIDATION = false;
    public static final int DEFAULT_MAX_CONNECTIONS = 200;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 50;
    public static final long DEFAULT_TIME_TO_LIVE = 900L;
    public static final TimeUnit DEFAULT_TIME_TO_LIVE_UNIT = TimeUnit.SECONDS;
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 2000;
    public static final int DEFAULT_CONNECTION_TIMER_REPEAT = 3000;
    private boolean disableSslValidation = false;
    private int maxConnections = 200;
    private int maxConnectionsPerRoute = 50;
    private long timeToLive = 900L;
    private TimeUnit timeToLiveUnit = DEFAULT_TIME_TO_LIVE_UNIT;
    private boolean followRedirects = true;
    private int connectionTimeout = 2000;
    private int connectionTimerRepeat = 3000;
    private Hc5Properties hc5 = new Hc5Properties();
    private OkHttp okHttp = new OkHttp();

    public int getConnectionTimerRepeat() {
        return this.connectionTimerRepeat;
    }

    public void setConnectionTimerRepeat(int connectionTimerRepeat) {
        this.connectionTimerRepeat = connectionTimerRepeat;
    }

    public boolean isDisableSslValidation() {
        return this.disableSslValidation;
    }

    public void setDisableSslValidation(boolean disableSslValidation) {
        this.disableSslValidation = disableSslValidation;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public TimeUnit getTimeToLiveUnit() {
        return this.timeToLiveUnit;
    }

    public void setTimeToLiveUnit(TimeUnit timeToLiveUnit) {
        this.timeToLiveUnit = timeToLiveUnit;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Hc5Properties getHc5() {
        return this.hc5;
    }

    public void setHc5(Hc5Properties hc5) {
        this.hc5 = hc5;
    }

    public OkHttp getOkHttp() {
        return this.okHttp;
    }

    public void setOkHttp(OkHttp okHttp) {
        this.okHttp = okHttp;
    }

    public static class OkHttp {
        private Duration readTimeout = Duration.ofSeconds(60L);

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }
    }

    public static class Hc5Properties {
        public static final PoolConcurrencyPolicy DEFAULT_POOL_CONCURRENCY_POLICY = PoolConcurrencyPolicy.STRICT;
        public static final PoolReusePolicy DEFAULT_POOL_REUSE_POLICY = PoolReusePolicy.FIFO;
        public static final int DEFAULT_SOCKET_TIMEOUT = 5;
        public static final TimeUnit DEFAULT_SOCKET_TIMEOUT_UNIT = TimeUnit.SECONDS;
        private PoolConcurrencyPolicy poolConcurrencyPolicy = DEFAULT_POOL_CONCURRENCY_POLICY;
        private PoolReusePolicy poolReusePolicy = DEFAULT_POOL_REUSE_POLICY;
        private int socketTimeout = 5;
        private TimeUnit socketTimeoutUnit = DEFAULT_SOCKET_TIMEOUT_UNIT;

        public PoolConcurrencyPolicy getPoolConcurrencyPolicy() {
            return this.poolConcurrencyPolicy;
        }

        public void setPoolConcurrencyPolicy(PoolConcurrencyPolicy poolConcurrencyPolicy) {
            this.poolConcurrencyPolicy = poolConcurrencyPolicy;
        }

        public PoolReusePolicy getPoolReusePolicy() {
            return this.poolReusePolicy;
        }

        public void setPoolReusePolicy(PoolReusePolicy poolReusePolicy) {
            this.poolReusePolicy = poolReusePolicy;
        }

        public TimeUnit getSocketTimeoutUnit() {
            return this.socketTimeoutUnit;
        }

        public void setSocketTimeoutUnit(TimeUnit socketTimeoutUnit) {
            this.socketTimeoutUnit = socketTimeoutUnit;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
        }

        public static enum PoolReusePolicy {
            LIFO,
            FIFO;

        }

        public static enum PoolConcurrencyPolicy {
            LAX,
            STRICT;

        }
    }
}

