/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.openfeign.security.OAuth2FeignRequestInterceptor;
import org.springframework.cloud.openfeign.security.OAuth2FeignRequestInterceptorConfigurer;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.OAuth2AccessTokenSupport;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;

public class OAuth2FeignRequestInterceptorBuilder {
    private AccessTokenProvider accessTokenProvider;
    private final List<ClientHttpRequestInterceptor> accessTokenProviderInterceptors = new ArrayList<ClientHttpRequestInterceptor>();

    public OAuth2FeignRequestInterceptorBuilder() {
        this.accessTokenProvider = new AccessTokenProviderChain(Arrays.asList(new AuthorizationCodeAccessTokenProvider(), new ImplicitAccessTokenProvider(), new ResourceOwnerPasswordAccessTokenProvider(), new ClientCredentialsAccessTokenProvider()));
    }

    public OAuth2FeignRequestInterceptorBuilder withAccessTokenProviderInterceptors(ClientHttpRequestInterceptor ... interceptors) {
        this.accessTokenProviderInterceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    OAuth2FeignRequestInterceptor build(OAuth2ClientContext oAuth2ClientContext, OAuth2ProtectedResourceDetails resource) {
        if (OAuth2AccessTokenSupport.class.isAssignableFrom(this.accessTokenProvider.getClass())) {
            ((OAuth2AccessTokenSupport)this.accessTokenProvider).setInterceptors(this.accessTokenProviderInterceptors);
        }
        OAuth2FeignRequestInterceptor feignRequestInterceptor = new OAuth2FeignRequestInterceptor(oAuth2ClientContext, resource);
        feignRequestInterceptor.setAccessTokenProvider(this.accessTokenProvider);
        return feignRequestInterceptor;
    }

    public static OAuth2FeignRequestInterceptor buildWithConfigurers(OAuth2ClientContext oAuth2ClientContext, OAuth2ProtectedResourceDetails resource, List<OAuth2FeignRequestInterceptorConfigurer> buildConfigurers) {
        OAuth2FeignRequestInterceptorBuilder builder = new OAuth2FeignRequestInterceptorBuilder();
        for (OAuth2FeignRequestInterceptorConfigurer configurer : buildConfigurers) {
            configurer.customize(builder);
        }
        return builder.build(oAuth2ClientContext, resource);
    }
}

