/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.clientconfig;

import jakarta.annotation.PreDestroy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={CloseableHttpClient.class})
public class HttpClient5FeignConfiguration {
    private static final Log LOG = LogFactory.getLog(HttpClient5FeignConfiguration.class);
    private CloseableHttpClient httpClient5;

    @Bean
    @ConditionalOnMissingBean(value={HttpClientConnectionManager.class})
    public HttpClientConnectionManager hc5ConnectionManager(FeignHttpClientProperties httpClientProperties) {
        return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(this.httpsSSLConnectionSocketFactory(httpClientProperties.isDisableSslValidation())).setMaxConnTotal(httpClientProperties.getMaxConnections()).setMaxConnPerRoute(httpClientProperties.getMaxConnectionsPerRoute()).setConnPoolPolicy(PoolReusePolicy.valueOf((String)httpClientProperties.getHc5().getPoolReusePolicy().name())).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.valueOf((String)httpClientProperties.getHc5().getPoolConcurrencyPolicy().name())).setConnectionTimeToLive(TimeValue.of((long)httpClientProperties.getTimeToLive(), (TimeUnit)httpClientProperties.getTimeToLiveUnit())).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.of((long)httpClientProperties.getHc5().getSocketTimeout(), (TimeUnit)httpClientProperties.getHc5().getSocketTimeoutUnit())).build()).build();
    }

    @Bean
    public CloseableHttpClient httpClient5(HttpClientConnectionManager connectionManager, FeignHttpClientProperties httpClientProperties) {
        this.httpClient5 = HttpClients.custom().disableCookieManagement().useSystemProperties().setConnectionManager(connectionManager).evictExpiredConnections().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(Timeout.of((long)httpClientProperties.getConnectionTimeout(), (TimeUnit)TimeUnit.MILLISECONDS)).setRedirectsEnabled(httpClientProperties.isFollowRedirects()).setConnectionRequestTimeout(Timeout.of((long)httpClientProperties.getHc5().getConnectionRequestTimeout(), (TimeUnit)httpClientProperties.getHc5().getConnectionRequestTimeoutUnit())).build()).build();
        return this.httpClient5;
    }

    @PreDestroy
    public void destroy() {
        if (this.httpClient5 != null) {
            this.httpClient5.close(CloseMode.GRACEFUL);
        }
    }

    private LayeredConnectionSocketFactory httpsSSLConnectionSocketFactory(boolean isDisableSslValidation) {
        SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder = SSLConnectionSocketFactoryBuilder.create().setTlsVersions(new TLS[]{TLS.V_1_3, TLS.V_1_2});
        if (isDisableSslValidation) {
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new DisabledValidationTrustManager()}, new SecureRandom());
                sslConnectionSocketFactoryBuilder.setSslContext(sslContext);
                sslConnectionSocketFactoryBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                LOG.warn((Object)"Error creating SSLContext", (Throwable)e);
            }
        } else {
            sslConnectionSocketFactoryBuilder.setSslContext(SSLContexts.createSystemDefault());
        }
        return sslConnectionSocketFactoryBuilder.build();
    }

    static class DisabledValidationTrustManager
    implements X509TrustManager {
        DisabledValidationTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

