/*
 * Copyright 2013-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.openfeign;

import feign.Target;

/**
 * This target provides url wrapped under {@link Target}.
 *
 * @author Jasbir Singh
 * @author Olga Maciaszek-Sharma
 * @since 4.0.0
 */
public class RefreshableHardCodedTarget<T> extends Target.HardCodedTarget<T> {

	private final RefreshableUrl refreshableUrl;

	private final String cleanPath;

	@SuppressWarnings("unchecked")
	public RefreshableHardCodedTarget(Class type, String name, RefreshableUrl refreshableUrl) {
		super(type, name, refreshableUrl.getUrl());
		this.refreshableUrl = refreshableUrl;
		cleanPath = "";
	}

	@SuppressWarnings("unchecked")
	public RefreshableHardCodedTarget(Class type, String name, RefreshableUrl refreshableUrl, String cleanPath) {
		super(type, name, refreshableUrl.getUrl());
		this.refreshableUrl = refreshableUrl;
		this.cleanPath = cleanPath;
	}

	@Override
	public String url() {
		return refreshableUrl.getUrl() + cleanPath;
	}

}
