/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.schema.registry.controllers;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.cloud.schema.registry.config.SchemaServerProperties;
import org.springframework.cloud.schema.registry.model.Schema;
import org.springframework.cloud.schema.registry.repository.SchemaRepository;
import org.springframework.cloud.schema.registry.support.InvalidSchemaException;
import org.springframework.cloud.schema.registry.support.SchemaDeletionNotAllowedException;
import org.springframework.cloud.schema.registry.support.SchemaNotFoundException;
import org.springframework.cloud.schema.registry.support.SchemaValidator;
import org.springframework.cloud.schema.registry.support.UnsupportedFormatException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(path={"${spring.cloud.schema.server.path:}"})
public class ServerController {
    private final SchemaRepository repository;
    private final Map<String, SchemaValidator> validators;
    private final SchemaServerProperties schemaServerProperties;

    public ServerController(SchemaRepository repository, Map<String, SchemaValidator> validators, SchemaServerProperties schemaServerProperties) {
        Assert.notNull((Object)repository, (String)"cannot be null");
        Assert.notEmpty(validators, (String)"cannot be empty");
        this.repository = repository;
        this.validators = validators;
        this.schemaServerProperties = schemaServerProperties;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/"}, consumes={"application/json"}, produces={"application/json"})
    public synchronized ResponseEntity<Schema> register(@RequestBody Schema schema, UriComponentsBuilder builder) {
        Schema result;
        SchemaValidator validator = this.validators.get(schema.getFormat());
        if (validator == null) {
            throw new UnsupportedFormatException(String.format("Invalid format, supported types are: %s", StringUtils.collectionToCommaDelimitedString(this.validators.keySet())));
        }
        validator.validate(schema.getDefinition());
        List<Schema> registeredEntities = this.repository.findBySubjectAndFormatOrderByVersion(schema.getSubject(), schema.getFormat());
        if (registeredEntities.isEmpty()) {
            schema.setVersion(1);
            result = (Schema)this.repository.save(schema);
        } else {
            result = validator.match(registeredEntities, schema.getDefinition());
            if (result == null) {
                schema.setVersion(registeredEntities.get(registeredEntities.size() - 1).getVersion() + 1);
                result = (Schema)this.repository.save(schema);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Location", builder.path("/{subject}/{format}/v{version}").buildAndExpand(new Object[]{result.getSubject(), result.getFormat(), result.getVersion()}).toString());
        ResponseEntity response = new ResponseEntity((Object)result, (MultiValueMap)headers, HttpStatus.CREATED);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, path={"/{subject}/{format}/v{version}"})
    public ResponseEntity<Schema> findOne(@PathVariable(value="subject") String subject, @PathVariable(value="format") String format, @PathVariable(value="version") Integer version) {
        Schema schema = this.repository.findOneBySubjectAndFormatAndVersion(subject, format, version);
        if (schema == null) {
            throw new SchemaNotFoundException(String.format("Could not find Schema by subject: %s, format: %s, version %s", subject, format, version));
        }
        return new ResponseEntity((Object)schema, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, path={"/schemas/{id}"})
    public ResponseEntity<Schema> findOne(@PathVariable(value="id") Integer id) {
        Optional schema = this.repository.findById(id);
        if (!schema.isPresent()) {
            throw new SchemaNotFoundException(String.format("Could not find Schema by id: %s", id));
        }
        return new ResponseEntity(schema.get(), HttpStatus.OK);
    }

    @Deprecated
    public ResponseEntity<List<Schema>> findBySubjectAndVersion(@PathVariable(value="subject") String subject, @PathVariable(value="format") String format) {
        return this.findBySubjectAndFormatOrderByVersionAsc(subject, format);
    }

    @GetMapping(produces={"application/json"}, path={"/{subject}/{format}"})
    @NonNull
    public ResponseEntity<List<Schema>> findBySubjectAndFormat(@NonNull @PathVariable(value="subject") String subject, @NonNull @PathVariable(value="format") String format) {
        return this.findBySubjectAndFormatOrderByVersionAsc(subject, format);
    }

    @RequestMapping(value={"/{subject}/{format}/v{version}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable(value="subject") String subject, @PathVariable(value="format") String format, @PathVariable(value="version") Integer version) {
        Schema schema;
        if (this.schemaServerProperties.isAllowSchemaDeletion()) {
            schema = this.repository.findOneBySubjectAndFormatAndVersion(subject, format, version);
            if (schema == null) {
                throw new SchemaNotFoundException(String.format("Could not find Schema by subject: %s, format: %s, version %s", subject, format, version));
            }
        } else {
            throw new SchemaDeletionNotAllowedException(String.format("Not permitted deletion of Schema by subject: %s, format: %s, version %s", subject, format, version));
        }
        this.deleteSchema(schema);
    }

    @RequestMapping(value={"/schemas/{id}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable(value="id") Integer id) {
        Optional schema;
        if (this.schemaServerProperties.isAllowSchemaDeletion()) {
            schema = this.repository.findById(id);
            if (!schema.isPresent()) {
                throw new SchemaNotFoundException(String.format("Could not find Schema by id: %s", id));
            }
        } else {
            throw new SchemaDeletionNotAllowedException(String.format("Not permitted deletion of Schema by id: %s", id));
        }
        this.deleteSchema((Schema)schema.get());
    }

    @RequestMapping(value={"/{subject}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable(value="subject") String subject) {
        if (this.schemaServerProperties.isAllowSchemaDeletion()) {
            for (Schema schema : this.repository.findAll()) {
                if (!schema.getSubject().equals(subject)) continue;
                this.deleteSchema(schema);
            }
        } else {
            throw new SchemaDeletionNotAllowedException(String.format("Not permitted deletion of Schema by subject: %s", subject));
        }
    }

    @NonNull
    public final ResponseEntity<List<Schema>> findBySubjectAndFormatOrderByVersionAsc(@NonNull String subject, @NonNull String format) {
        List<Schema> schemas = this.repository.findBySubjectAndFormatOrderByVersion(subject, format);
        if (schemas.isEmpty()) {
            throw new SchemaNotFoundException(String.format("No schemas found for subject %s and format %s", subject, format));
        }
        return new ResponseEntity(schemas, HttpStatus.OK);
    }

    private void deleteSchema(Schema schema) {
        if (schema == null) {
            throw new SchemaNotFoundException("Could not find Schema");
        }
        this.repository.delete(schema);
    }

    @ExceptionHandler(value={UnsupportedFormatException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public String onUnsupportedFormat(UnsupportedFormatException e) {
        return this.errorMessage("Format not supported", e);
    }

    @ExceptionHandler(value={InvalidSchemaException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public String onInvalidSchema(InvalidSchemaException e) {
        return this.errorMessage("Invalid Schema", e);
    }

    @ExceptionHandler(value={SchemaNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public String schemaNotFound(SchemaNotFoundException ex) {
        return this.errorMessage("Schema not found", ex);
    }

    @ExceptionHandler(value={SchemaDeletionNotAllowedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    @ResponseBody
    public String schemaDeletionNotPermitted(SchemaDeletionNotAllowedException ex) {
        return this.errorMessage("Schema deletion is not permitted", ex);
    }

    private String errorMessage(String prefix, Throwable e) {
        return prefix + (StringUtils.hasText((String)e.getMessage()) ? ": " + e.getMessage() : "");
    }
}

