/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.schema.registry.support;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.springframework.cloud.schema.registry.model.Compatibility;
import org.springframework.cloud.schema.registry.support.InvalidSchemaException;
import org.springframework.cloud.schema.registry.support.SchemaValidator;

public class AvroSchemaValidator
implements SchemaValidator {
    public static final String AVRO_FORMAT = "avro";

    @Override
    public boolean isValid(String definition) {
        boolean result = true;
        try {
            new Schema.Parser().parse(definition);
        }
        catch (SchemaParseException ex) {
            result = false;
        }
        return result;
    }

    @Override
    public void validate(String definition) {
        try {
            new Schema.Parser().parse(definition);
        }
        catch (SchemaParseException ex) {
            throw new InvalidSchemaException(ex.getMessage());
        }
    }

    @Override
    public Compatibility compatibilityCheck(String source, String other) {
        return null;
    }

    @Override
    public org.springframework.cloud.schema.registry.model.Schema match(List<org.springframework.cloud.schema.registry.model.Schema> schemas, String definition) {
        org.springframework.cloud.schema.registry.model.Schema result = null;
        Schema source = new Schema.Parser().parse(definition);
        for (org.springframework.cloud.schema.registry.model.Schema s : schemas) {
            Schema target = new Schema.Parser().parse(s.getDefinition());
            if (!target.equals((Object)source)) continue;
            result = s;
            break;
        }
        return result;
    }

    @Override
    public String getFormat() {
        return AVRO_FORMAT;
    }
}

