/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.io;

import org.springframework.cloud.skipper.domain.PackageMetadata;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

class PackageMetadataSafeConstructor
extends SafeConstructor {
    private static final String API_VERSION = "apiVersion";
    private static final String ORIGIN = "origin";
    private static final String REPOSITORY_ID = "repositoryId";
    private static final String REPOSITORY_NAME = "repositoryName";
    private static final String PACKAGE_KIND = "kind";
    private static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String PACKAGE_VERSION = "version";
    private static final String PACKAGE_SOURCE_URL = "packageSourceUrl";
    private static final String PACKAGE_HOME_URL = "packageHomeUrl";
    private static final String TAGS = "tags";
    private static final String MAINTAINER = "maintainer";
    private static final String DESCRIPTION = "description";
    private static final String SHA256 = "sha256";
    private static final String ICON_URL = "iconUrl";

    PackageMetadataSafeConstructor(LoaderOptions loadingConfig) {
        super(loadingConfig);
        this.yamlConstructors.put(new TypeDescription(PackageMetadata.class).getTag(), new ConstructYamlPackageMetadata());
        this.rootTag = new Tag(new TypeDescription(PackageMetadata.class).getType());
    }

    private class ConstructYamlPackageMetadata
    implements Construct {
        private ConstructYamlPackageMetadata() {
        }

        public Object construct(Node node) {
            MappingNode mappingNode = (MappingNode)node;
            PackageMetadata packageMetadata = new PackageMetadata();
            try {
                for (NodeTuple tuple : mappingNode.getValue()) {
                    ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                    ScalarNode valueNode = (ScalarNode)tuple.getValueNode();
                    String key = keyNode.getValue();
                    this.setKeyValue(packageMetadata, key, valueNode.getValue());
                }
            }
            catch (ClassCastException cce) {
                throw new YAMLException("Unable to Parse yaml to PackageMetadata type", (Throwable)cce);
            }
            return packageMetadata;
        }

        public void construct2ndStep(Node node, Object object) {
        }

        public PackageMetadata setKeyValue(PackageMetadata packageMetadata, String key, String value) {
            switch (key) {
                case "apiVersion": {
                    packageMetadata.setApiVersion(value);
                    break;
                }
                case "origin": {
                    packageMetadata.setOrigin(value);
                    break;
                }
                case "repositoryId": {
                    packageMetadata.setRepositoryId(this.isLong(value) ? Long.valueOf(Long.parseLong(value)) : null);
                    break;
                }
                case "repositoryName": {
                    packageMetadata.setRepositoryName(value);
                    break;
                }
                case "kind": {
                    packageMetadata.setKind(value);
                    break;
                }
                case "name": {
                    packageMetadata.setName(value);
                    break;
                }
                case "displayName": {
                    packageMetadata.setDisplayName(value);
                    break;
                }
                case "version": {
                    packageMetadata.setVersion(value);
                    break;
                }
                case "packageSourceUrl": {
                    packageMetadata.setPackageSourceUrl(value);
                    break;
                }
                case "packageHomeUrl": {
                    packageMetadata.setPackageHomeUrl(value);
                    break;
                }
                case "tags": {
                    packageMetadata.setTags(value);
                    break;
                }
                case "maintainer": {
                    packageMetadata.setMaintainer(value);
                    break;
                }
                case "description": {
                    packageMetadata.setDescription(value);
                    break;
                }
                case "sha256": {
                    packageMetadata.setSha256(value);
                    break;
                }
                case "iconUrl": {
                    packageMetadata.setIconUrl(value);
                }
            }
            return packageMetadata;
        }

        private boolean isLong(String str) {
            if (str == null || str.isEmpty()) {
                return false;
            }
            try {
                Long.parseLong(str);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

